/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;

public class ActiveMQRAService {
    private final MBeanServer mBeanServer;
    private final String resourceAdapterObjectName;

    public ActiveMQRAService(MBeanServer mBeanServer, String resourceAdapterObjectName) {
        this.mBeanServer = mBeanServer;
        this.resourceAdapterObjectName = resourceAdapterObjectName;
    }

    public void stop() {
        try {
            ObjectName objectName = new ObjectName(this.resourceAdapterObjectName);
            Set<ObjectInstance> mbeanSet = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance mbean : mbeanSet) {
                String stateString = (String)this.mBeanServer.getAttribute(mbean.getObjectName(), "StateString");
                if (!"Started".equalsIgnoreCase(stateString) && !"Starting".equalsIgnoreCase(stateString)) continue;
                this.mBeanServer.invoke(mbean.getObjectName(), "stop", new Object[0], new String[0]);
            }
        }
        catch (Exception e) {
            ActiveMQRALogger.LOGGER.errorStoppingRA(e);
        }
    }
}

