/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;

class LoggingResourceTransformer
implements ResourceTransformer {
    private final AttributeDefinition[] removableAttributes;

    public LoggingResourceTransformer(AttributeDefinition ... removableAttributes) {
        this.removableAttributes = removableAttributes;
    }

    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        this.doTransform(resource);
        ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
        childContext.processChildren(resource);
    }

    private void doTransform(Resource resource) {
        ModelNode model = resource.getModel();
        for (AttributeDefinition attribute : this.removableAttributes) {
            if (!model.has(attribute.getName())) continue;
            LoggingLogger.ROOT_LOGGER.debugf("Removing attribute '%s' during transform", attribute.getName());
            model.remove(attribute.getName());
        }
    }
}

