/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ScheduledDeliveryHandler;

public class ScheduledDeliveryHandlerImpl
implements ScheduledDeliveryHandler {
    private static final boolean trace = ActiveMQServerLogger.LOGGER.isTraceEnabled();
    private final ScheduledExecutorService scheduledExecutor;
    private final Map<Long, Runnable> runnables = new ConcurrentHashMap<Long, Runnable>();
    private final TreeSet<RefScheduled> scheduledReferences = new TreeSet<RefScheduled>(new MessageReferenceComparator());

    public ScheduledDeliveryHandlerImpl(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    @Override
    public boolean checkAndSchedule(MessageReference ref, boolean tail) {
        long deliveryTime = ref.getScheduledDeliveryTime();
        if (deliveryTime > 0L && this.scheduledExecutor != null) {
            if (trace) {
                ActiveMQServerLogger.LOGGER.trace("Scheduling delivery for " + ref + " to occur at " + deliveryTime);
            }
            this.addInPlace(deliveryTime, ref, tail);
            this.scheduleDelivery(deliveryTime);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInPlace(long deliveryTime, MessageReference ref, boolean tail) {
        TreeSet<RefScheduled> treeSet = this.scheduledReferences;
        synchronized (treeSet) {
            this.scheduledReferences.add(new RefScheduled(ref, tail));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScheduledCount() {
        TreeSet<RefScheduled> treeSet = this.scheduledReferences;
        synchronized (treeSet) {
            return this.scheduledReferences.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getScheduledReferences() {
        LinkedList<MessageReference> refs = new LinkedList<MessageReference>();
        TreeSet<RefScheduled> treeSet = this.scheduledReferences;
        synchronized (treeSet) {
            for (RefScheduled ref : this.scheduledReferences) {
                refs.add(ref.getRef());
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> cancel(Filter filter) {
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        TreeSet<RefScheduled> treeSet = this.scheduledReferences;
        synchronized (treeSet) {
            Iterator<RefScheduled> iter = this.scheduledReferences.iterator();
            while (iter.hasNext()) {
                MessageReference ref = iter.next().getRef();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                iter.remove();
                refs.add(ref);
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReference removeReferenceWithID(long id) {
        TreeSet<RefScheduled> treeSet = this.scheduledReferences;
        synchronized (treeSet) {
            Iterator<RefScheduled> iter = this.scheduledReferences.iterator();
            while (iter.hasNext()) {
                MessageReference ref = iter.next().getRef();
                if (ref.getMessage().getMessageID() != id) continue;
                iter.remove();
                return ref;
            }
        }
        return null;
    }

    private void scheduleDelivery(long deliveryTime) {
        long now = System.currentTimeMillis();
        long delay = deliveryTime - now;
        if (delay < 0L) {
            if (trace) {
                ActiveMQServerLogger.LOGGER.trace("calling another scheduler now as deliverTime " + deliveryTime + " < now=" + now);
            }
            ScheduledDeliveryRunnable runnable = new ScheduledDeliveryRunnable(deliveryTime);
            this.scheduledExecutor.schedule(runnable, 0L, TimeUnit.MILLISECONDS);
        } else if (!this.runnables.containsKey(deliveryTime)) {
            ScheduledDeliveryRunnable runnable = new ScheduledDeliveryRunnable(deliveryTime);
            if (trace) {
                ActiveMQServerLogger.LOGGER.trace("Setting up scheduler for " + deliveryTime + " with a delay of " + delay + " as now=" + now);
            }
            this.runnables.put(deliveryTime, runnable);
            this.scheduledExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        } else if (trace) {
            ActiveMQServerLogger.LOGGER.trace("Couldn't make another scheduler as " + deliveryTime + " is already set, now is " + now);
        }
    }

    static class MessageReferenceComparator
    implements Comparator<RefScheduled> {
        MessageReferenceComparator() {
        }

        @Override
        public int compare(RefScheduled ref1, RefScheduled ref2) {
            long diff = ref1.getRef().getScheduledDeliveryTime() - ref2.getRef().getScheduledDeliveryTime();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            if (ref1 == ref2) {
                return 0;
            }
            if (ref1.isTail() && !ref2.isTail()) {
                return 1;
            }
            if (!ref1.isTail() && ref2.isTail()) {
                return -1;
            }
            if (!ref1.isTail() && !ref2.isTail()) {
                return -1;
            }
            return 1;
        }
    }

    class RefScheduled {
        private final MessageReference ref;
        private final boolean tail;

        RefScheduled(MessageReference ref, boolean tail) {
            this.ref = ref;
            this.tail = tail;
        }

        public MessageReference getRef() {
            return this.ref;
        }

        public boolean isTail() {
            return this.tail;
        }
    }

    private class ScheduledDeliveryRunnable
    implements Runnable {
        long deliveryTime;

        public ScheduledDeliveryRunnable(long deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<Queue, LinkedList<MessageReference>> refs = new HashMap<Queue, LinkedList<MessageReference>>();
            ScheduledDeliveryHandlerImpl.this.runnables.remove(this.deliveryTime);
            long now = System.currentTimeMillis();
            if (now < this.deliveryTime) {
                if (trace) {
                    ActiveMQServerLogger.LOGGER.trace("Scheduler is working around OS imprecisions on timing and re-scheduling an executor. now=" + now + " and deliveryTime=" + this.deliveryTime);
                }
                ScheduledDeliveryHandlerImpl.this.scheduleDelivery(this.deliveryTime);
            }
            if (trace) {
                ActiveMQServerLogger.LOGGER.trace("Is it " + System.currentTimeMillis() + " now and we are running deliveryTime = " + this.deliveryTime);
            }
            TreeSet treeSet = ScheduledDeliveryHandlerImpl.this.scheduledReferences;
            synchronized (treeSet) {
                MessageReference reference;
                Iterator iterator = ScheduledDeliveryHandlerImpl.this.scheduledReferences.iterator();
                while (iterator.hasNext() && (reference = ((RefScheduled)iterator.next()).getRef()).getScheduledDeliveryTime() <= now) {
                    iterator.remove();
                    reference.setScheduledDeliveryTime(0L);
                    LinkedList<MessageReference> references = (LinkedList<MessageReference>)refs.get(reference.getQueue());
                    if (references == null) {
                        references = new LinkedList<MessageReference>();
                        refs.put(reference.getQueue(), references);
                    }
                    if (trace) {
                        ActiveMQServerLogger.LOGGER.trace("sending message " + reference + " to delivery, deliveryTime =  " + this.deliveryTime);
                    }
                    references.addFirst(reference);
                }
                if (trace) {
                    ActiveMQServerLogger.LOGGER.trace("Finished loop on deliveryTime = " + this.deliveryTime);
                }
            }
            for (Map.Entry entry : refs.entrySet()) {
                Queue queue = (Queue)entry.getKey();
                LinkedList list = (LinkedList)entry.getValue();
                if (trace) {
                    ActiveMQServerLogger.LOGGER.trace("Delivering " + list.size() + " elements on list to queue " + queue);
                }
                queue.addHead(list);
            }
            refs.clear();
        }
    }
}

