/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model.parser;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.XMLElement;
import org.wildfly.extension.picketlink.idm.Namespace;
import org.wildfly.extension.picketlink.idm.model.CredentialHandlerResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.FileStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.IdentityConfigurationResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.JPAStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreAttributeResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreMappingResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.LDAPStoreResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.SupportedTypeResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.SupportedTypesResourceDefinition;

public abstract class AbstractIDMSubsystemReader
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> addOperations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        Namespace nameSpace = Namespace.forUri(reader.getNamespaceURI());
        ModelNode subsystemNode = this.createSubsystemRoot();
        addOperations.add(subsystemNode);
        switch (nameSpace) {
            case PICKETLINK_IDENTITY_MANAGEMENT_1_0: {
                this.readElement(reader, subsystemNode, addOperations);
                break;
            }
            case PICKETLINK_IDENTITY_MANAGEMENT_2_0: {
                this.readElement(reader, subsystemNode, addOperations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void readElement(XMLExtendedStreamReader reader, ModelNode subsystemNode, List<ModelNode> addOperations) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 8) {
            if (!reader.isStartElement() || XMLElement.forName(reader.getLocalName()) != null) continue;
            ModelElement modelKey = ModelElement.forName(reader.getLocalName());
            if (modelKey == null) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (modelKey) {
                case PARTITION_MANAGER: {
                    this.parseIdentityManagementConfig(reader, subsystemNode, addOperations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIdentityManagementConfig(XMLExtendedStreamReader reader, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode identityManagementNode = this.parseConfig(reader, ModelElement.PARTITION_MANAGER, ModelElement.COMMON_NAME.getName(), parentNode, PartitionManagerResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_CONFIGURATION: {
                        AbstractIDMSubsystemReader.this.parseIdentityConfigurationConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.PARTITION_MANAGER, identityManagementNode, reader, addOperations);
    }

    private void parseIdentityConfigurationConfig(XMLExtendedStreamReader reader, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode identityConfigurationNode = this.parseConfig(reader, ModelElement.IDENTITY_CONFIGURATION, ModelElement.COMMON_NAME.getName(), parentNode, IdentityConfigurationResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case JPA_STORE: {
                        AbstractIDMSubsystemReader.this.parseJPAStoreConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case FILE_STORE: {
                        AbstractIDMSubsystemReader.this.parseFileStoreConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case LDAP_STORE: {
                        AbstractIDMSubsystemReader.this.parseLDAPStoreConfig(reader, addOperations, parentNode);
                    }
                }
            }
        }, ModelElement.IDENTITY_CONFIGURATION, identityConfigurationNode, reader, addOperations);
    }

    private void parseJPAStoreConfig(XMLExtendedStreamReader reader, ModelNode identityConfigurationNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode jpaStoreNode = this.parseConfig(reader, ModelElement.JPA_STORE, null, identityConfigurationNode, JPAStoreResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_STORE_CREDENTIAL_HANDLER: {
                        AbstractIDMSubsystemReader.this.parseCredentialHandlerConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case SUPPORTED_TYPES: {
                        AbstractIDMSubsystemReader.this.parseSupportedTypesConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.JPA_STORE, jpaStoreNode, reader, addOperations);
    }

    private void parseFileStoreConfig(XMLExtendedStreamReader reader, ModelNode identityManagementNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode fileStoreNode = this.parseConfig(reader, ModelElement.FILE_STORE, null, identityManagementNode, FileStoreResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_STORE_CREDENTIAL_HANDLER: {
                        AbstractIDMSubsystemReader.this.parseCredentialHandlerConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case SUPPORTED_TYPES: {
                        AbstractIDMSubsystemReader.this.parseSupportedTypesConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.FILE_STORE, fileStoreNode, reader, addOperations);
    }

    private void parseLDAPStoreConfig(XMLExtendedStreamReader reader, List<ModelNode> addOperations, ModelNode identityManagementNode) throws XMLStreamException {
        ModelNode ldapStoreNode = this.parseConfig(reader, ModelElement.LDAP_STORE, null, identityManagementNode, LDAPStoreResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_STORE_CREDENTIAL_HANDLER: {
                        AbstractIDMSubsystemReader.this.parseCredentialHandlerConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case LDAP_STORE_MAPPING: {
                        AbstractIDMSubsystemReader.this.parseLDAPMappingConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case SUPPORTED_TYPES: {
                        AbstractIDMSubsystemReader.this.parseSupportedTypesConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.LDAP_STORE, ldapStoreNode, reader, addOperations);
    }

    protected void parseLDAPMappingConfig(XMLExtendedStreamReader reader, ModelNode identityProviderNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode ldapMappingConfig = this.parseConfig(reader, ModelElement.LDAP_STORE_MAPPING, ModelElement.COMMON_NAME.getName(), identityProviderNode, LDAPStoreMappingResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case LDAP_STORE_ATTRIBUTE: {
                        AbstractIDMSubsystemReader.this.parseConfig(reader, ModelElement.LDAP_STORE_ATTRIBUTE, LDAPStoreAttributeResourceDefinition.NAME.getName(), parentNode, LDAPStoreAttributeResourceDefinition.INSTANCE.getAttributes(), addOperations);
                    }
                }
            }
        }, ModelElement.LDAP_STORE_MAPPING, ldapMappingConfig, reader, addOperations);
    }

    protected ModelNode parseCredentialHandlerConfig(XMLExtendedStreamReader reader, ModelNode identityProviderNode, List<ModelNode> addOperations) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER, ModelElement.COMMON_NAME.getName(), identityProviderNode, CredentialHandlerResourceDefinition.INSTANCE.getAttributes(), addOperations);
    }

    private ModelNode parseSupportedTypesConfig(XMLExtendedStreamReader reader, ModelNode identityStoreNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode supportedTypesNode = this.parseConfig(reader, ModelElement.SUPPORTED_TYPES, null, identityStoreNode, SupportedTypesResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case SUPPORTED_TYPE: {
                        AbstractIDMSubsystemReader.this.parseSupportedTypeConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.SUPPORTED_TYPES, supportedTypesNode, reader, addOperations);
        return supportedTypesNode;
    }

    protected void parseSupportedTypeConfig(XMLExtendedStreamReader reader, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
        this.parseConfig(reader, ModelElement.SUPPORTED_TYPE, ModelElement.COMMON_NAME.getName(), parentNode, SupportedTypeResourceDefinition.INSTANCE.getAttributes(), addOperations);
    }

    private ModelNode createSubsystemRoot() {
        ModelNode subsystemAddress = new ModelNode();
        subsystemAddress.add("subsystem", "picketlink-identity-management");
        subsystemAddress.protect();
        return Util.getEmptyOperation((String)"add", (ModelNode)subsystemAddress);
    }

    protected ModelNode parseConfig(XMLExtendedStreamReader reader, ModelElement xmlElement, String key, ModelNode lastNode, List<SimpleAttributeDefinition> attributes, List<ModelNode> addOperations) throws XMLStreamException {
        if (!reader.getLocalName().equals(xmlElement.getName())) {
            return null;
        }
        ModelNode modelNode = Util.getEmptyOperation((String)"add", null);
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeLocalName = reader.getAttributeLocalName(i);
            if (ModelElement.forName(attributeLocalName) != null) continue;
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : attributes) {
            simpleAttributeDefinition.parseAndSetParameter(reader.getAttributeValue("", simpleAttributeDefinition.getXmlName()), modelNode, (XMLStreamReader)reader);
        }
        String name = xmlElement.getName();
        if (key != null) {
            name = key;
            if (modelNode.hasDefined(key)) {
                name = modelNode.get(key).asString();
            } else {
                String attributeValue = reader.getAttributeValue("", key);
                if (attributeValue != null) {
                    name = attributeValue;
                }
            }
        }
        modelNode.get("address").set(lastNode.clone().get("address").add(xmlElement.getName(), name));
        addOperations.add(modelNode);
        return modelNode;
    }

    protected void parseElement(ElementParser parser, ModelElement parentElement, ModelNode parentNode, XMLExtendedStreamReader reader, List<ModelNode> addOperations) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 8) {
            if (!reader.isStartElement()) {
                if (!reader.isEndElement() || !reader.getLocalName().equals(parentElement.getName())) continue;
                break;
            }
            if (reader.getLocalName().equals(parentElement.getName())) continue;
            ModelElement element = ModelElement.forName(reader.getLocalName());
            if (element == null) {
                if (XMLElement.forName(reader.getLocalName()) != null) continue;
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            parser.parse(reader, element, parentNode, addOperations);
        }
    }

    protected static interface ElementParser {
        public void parse(XMLExtendedStreamReader var1, ModelElement var2, ModelNode var3, List<ModelNode> var4) throws XMLStreamException;
    }
}

