/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationMessage;

class DelegatingMessageFactory
extends MessageFactory {
    private List<MessageFactory> delegates;

    DelegatingMessageFactory(List<MessageFactory> delegates) {
        this.delegates = delegates;
    }

    @Override
    public boolean accepts(InputStream in) throws IOException {
        for (MessageFactory current : this.delegates) {
            if (!current.accepts(in)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NegotiationMessage createMessage(InputStream in) throws IOException {
        for (MessageFactory current : this.delegates) {
            if (!current.accepts(in)) continue;
            return current.createMessage(in);
        }
        throw new IllegalStateException("No suitable MessageFactory found for message.");
    }
}

