/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.GuardedBy;
import org.hibernate.search.backend.BackendFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.query.indexmanager.IndexLockController;
import org.infinispan.query.indexmanager.IndexingBackend;
import org.infinispan.query.indexmanager.LazyInitializableBackend;
import org.infinispan.query.indexmanager.LazyInitializingBackend;
import org.infinispan.query.indexmanager.LocalBackendFactory;
import org.infinispan.query.indexmanager.LockAcquiringBackend;
import org.infinispan.query.indexmanager.RemoteIndexingBackend;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.LogFactory;

@Listener
final class ClusteredSwitchingBackend
implements LazyInitializableBackend {
    private static final Log log = (Log)LogFactory.getLog(ClusteredSwitchingBackend.class, Log.class);
    private static final int MAX_LOCK_ACQUISITION_ATTEMPTS = 2;
    private final Address localAddress;
    private final RpcManager rpcManager;
    private final LocalBackendFactory factory;
    private final IndexLockController indexlock;
    private final boolean async;
    private final String indexName;
    private final String cacheName;
    private final AtomicInteger lastSeenViewId = new AtomicInteger(-1);
    private volatile Address currentMaster;
    private volatile IndexingBackend currentBackend;
    @GuardedBy(value="this")
    private boolean initialized = false;
    @GuardedBy(value="this")
    private int masterLockAcquisitionAttempts = 0;

    ClusteredSwitchingBackend(Properties props, ComponentRegistry componentsRegistry, String indexName, LocalBackendFactory factory, IndexLockController indexlock) {
        this.indexName = indexName;
        this.factory = factory;
        this.indexlock = indexlock;
        this.rpcManager = (RpcManager)componentsRegistry.getComponent(RpcManager.class);
        this.cacheName = componentsRegistry.getCacheName();
        if (this.rpcManager == null) {
            throw new IllegalStateException("This Cache is not clustered! The switching backend should not be used for local caches");
        }
        this.localAddress = this.rpcManager.getAddress();
        this.currentBackend = new LazyInitializingBackend(this);
        this.async = !BackendFactory.isConfiguredAsSync((Properties)props);
    }

    @ViewChanged
    public void viewChanged(ViewChangedEvent e) {
        int currentViewId = this.lastSeenViewId.get();
        int viewId = e.getViewId();
        if (viewId > currentViewId && this.lastSeenViewId.compareAndSet(currentViewId, viewId)) {
            this.applyViewChangedEvent(e);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public synchronized void lazyInitialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        List members = this.rpcManager.getMembers();
        assert (members != null);
        assert (members.size() > 0);
        assert (members.get(0) != null);
        Address initialMaster = (Address)members.get(0);
        this.lastSeenViewId.set(this.rpcManager.getTransport().getViewId());
        if (this.thisIsNewMaster(initialMaster)) {
            this.acquireControlStart();
        } else {
            this.updateRoutingToNewRemote(initialMaster);
        }
    }

    private synchronized void applyViewChangedEvent(ViewChangedEvent e) {
        Address newmaster;
        assert (e != null);
        assert (e.getNewMembers().size() > 0);
        assert (e.getNewMembers().get(0) != null);
        if (log.isDebugEnabled()) {
            log.debug("Notified of new View! Members: " + e.getNewMembers());
        }
        if (this.masterDidChange(newmaster = (Address)e.getNewMembers().get(0))) {
            if (this.thisIsMaster()) {
                if (log.isDebugEnabled()) {
                    log.debug("No longer a MASTER node, releasing the index lock.");
                }
                this.forfeitControl(newmaster);
            } else if (this.thisIsNewMaster(newmaster)) {
                log.debug("Electing SELF as MASTER!");
                this.acquireControlStart();
            } else {
                this.updateRoutingToNewRemote(newmaster);
                if (log.isDebugEnabled()) {
                    log.debug("New master elected, now routing updates to node " + newmaster);
                }
            }
        }
    }

    private boolean thisIsNewMaster(Address newmaster) {
        return this.localAddress.equals(newmaster);
    }

    private boolean thisIsMaster() {
        return this.localAddress.equals(this.currentMaster);
    }

    private boolean masterDidChange(Address newmaster) {
        if (newmaster == null) {
            return false;
        }
        return !newmaster.equals(this.currentMaster);
    }

    private void updateRoutingToNewRemote(Address newMaster) {
        RemoteIndexingBackend newBackend = new RemoteIndexingBackend(this.cacheName, this.rpcManager, this.indexName, newMaster, this.async);
        this.swapNewBackendIn(newBackend, newMaster);
    }

    private void acquireControlStart() {
        LockAcquiringBackend backend = new LockAcquiringBackend(this);
        this.masterLockAcquisitionAttempts = 0;
        this.swapNewBackendIn(backend, this.localAddress);
    }

    private void forfeitControl(Address newMasterAddress) {
        RemoteIndexingBackend newBackend = new RemoteIndexingBackend(this.cacheName, this.rpcManager, this.indexName, newMasterAddress, this.async);
        this.swapNewBackendIn(newBackend, newMasterAddress);
    }

    private void swapNewBackendIn(IndexingBackend newBackend, Address newMasterAddress) {
        IndexingBackend oldBackend = this.currentBackend;
        log.debugv("Swapping from backend {0} to {1}'", oldBackend, newBackend);
        this.currentBackend = newBackend;
        this.currentMaster = newMasterAddress;
        ClusteredSwitchingBackend.closeBackend(oldBackend, this.currentBackend);
    }

    @Override
    public void shutdown() {
        ClusteredSwitchingBackend.closeBackend(this.currentBackend, null);
        this.currentBackend = null;
    }

    @Override
    public IndexingBackend getCurrentIndexingBackend() {
        return this.currentBackend;
    }

    private static void closeBackend(IndexingBackend oldOne, IndexingBackend replacement) {
        if (oldOne != null) {
            oldOne.flushAndClose(replacement);
        }
    }

    @Override
    public synchronized boolean attemptUpgrade(IndexingBackend expectedBackend) {
        log.trace("owning lock for attemptUpgrade(IndexingBackend)");
        if (this.currentBackend != expectedBackend) {
            return true;
        }
        if (this.masterLockAcquisitionAttempts >= 2) {
            this.indexlock.forceLockClear();
            this.swapNewBackendIn(this.factory.createLocalIndexingBackend(), this.localAddress);
            return true;
        }
        ++this.masterLockAcquisitionAttempts;
        if (this.indexlock.waitForAvailability()) {
            this.swapNewBackendIn(this.factory.createLocalIndexingBackend(), this.localAddress);
            return true;
        }
        log.trace("Index lock not available: index update operations postponed.");
        return false;
    }
}

