/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.message.DbException;
import org.h2.util.New;

public class JdbcConnectionPool
implements DataSource,
ConnectionEventListener {
    private static final int DEFAULT_TIMEOUT = 30;
    private static final int DEFAULT_MAX_CONNECTIONS = 10;
    private final ConnectionPoolDataSource dataSource;
    private final ArrayList<PooledConnection> recycledConnections = New.arrayList();
    private PrintWriter logWriter;
    private int maxConnections = 10;
    private int timeout = 30;
    private int activeConnections;
    private boolean isDisposed;

    protected JdbcConnectionPool(ConnectionPoolDataSource connectionPoolDataSource) {
        this.dataSource = connectionPoolDataSource;
        if (connectionPoolDataSource != null) {
            try {
                this.logWriter = connectionPoolDataSource.getLogWriter();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static JdbcConnectionPool create(ConnectionPoolDataSource connectionPoolDataSource) {
        return new JdbcConnectionPool(connectionPoolDataSource);
    }

    public static JdbcConnectionPool create(String string, String string2, String string3) {
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        jdbcDataSource.setURL(string);
        jdbcDataSource.setUser(string2);
        jdbcDataSource.setPassword(string3);
        return new JdbcConnectionPool(jdbcDataSource);
    }

    public synchronized void setMaxConnections(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid maxConnections value: " + n);
        }
        this.maxConnections = n;
        this.notifyAll();
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public synchronized int getLoginTimeout() {
        return this.timeout;
    }

    @Override
    public synchronized void setLoginTimeout(int n) {
        if (n == 0) {
            n = 30;
        }
        this.timeout = n;
    }

    public synchronized void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        ArrayList<PooledConnection> arrayList = this.recycledConnections;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.closeConnection(arrayList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        long l = System.currentTimeMillis() + (long)(this.timeout * 1000);
        do {
            JdbcConnectionPool jdbcConnectionPool = this;
            synchronized (jdbcConnectionPool) {
                if (this.activeConnections < this.maxConnections) {
                    return this.getConnectionNow();
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (System.currentTimeMillis() <= l);
        throw new SQLException("Login timeout", "08001", 8001);
    }

    @Override
    public Connection getConnection(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    private Connection getConnectionNow() throws SQLException {
        if (this.isDisposed) {
            throw new IllegalStateException("Connection pool has been disposed.");
        }
        PooledConnection pooledConnection = !this.recycledConnections.isEmpty() ? this.recycledConnections.remove(this.recycledConnections.size() - 1) : this.dataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        ++this.activeConnections;
        pooledConnection.addConnectionEventListener(this);
        return connection;
    }

    synchronized void recycleConnection(PooledConnection pooledConnection) {
        if (this.activeConnections <= 0) {
            throw new AssertionError();
        }
        --this.activeConnections;
        if (!this.isDisposed && this.activeConnections < this.maxConnections) {
            this.recycledConnections.add(pooledConnection);
        } else {
            this.closeConnection(pooledConnection);
        }
        if (this.activeConnections >= this.maxConnections - 1) {
            this.notifyAll();
        }
    }

    private void closeConnection(PooledConnection pooledConnection) {
        block2: {
            try {
                pooledConnection.close();
            }
            catch (SQLException sQLException) {
                if (this.logWriter == null) break block2;
                sQLException.printStackTrace(this.logWriter);
            }
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        pooledConnection.removeConnectionEventListener(this);
        this.recycleConnection(pooledConnection);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
    }

    public synchronized int getActiveConnections() {
        return this.activeConnections;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw DbException.getUnsupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw DbException.getUnsupportedException("isWrapperFor");
    }
}

