/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.dmr.ModelNode;

public class ProxyStepHandler
implements OperationStepHandler {
    private final ProxyController proxyController;
    private final boolean forServer;

    public ProxyStepHandler(ProxyController proxyController) {
        this.proxyController = proxyController;
        this.forServer = proxyController.getProxyNodeAddress().getLastElement().getKey().equals("server");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AtomicReference<OperationResponse> finalResultRef;
        AtomicReference<ModelNode> preparedResultRef;
        AtomicReference<ModelController.OperationTransaction> txRef;
        block8: {
            if (this.isWFCORE621Needed(operation, context.getCurrentAddress())) {
                this.executeWFCORE621(context, operation);
                return;
            }
            DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(context);
            txRef = new AtomicReference<ModelController.OperationTransaction>();
            preparedResultRef = new AtomicReference<ModelNode>();
            finalResultRef = new AtomicReference<OperationResponse>();
            final ProxyController.ProxyOperationControl proxyControl = new ProxyController.ProxyOperationControl(){

                @Override
                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                    txRef.set(transaction);
                    preparedResultRef.set(result);
                }

                @Override
                public void operationFailed(ModelNode response) {
                    finalResultRef.set(OperationResponse.Factory.createSimple((ModelNode)response));
                }

                @Override
                public void operationCompleted(OperationResponse response) {
                    finalResultRef.set(response);
                }
            };
            if (this.proxyController instanceof TransformingProxyController) {
                TransformingProxyController transformingProxyController = (TransformingProxyController)this.proxyController;
                final OperationTransformer.TransformedOperation result = transformingProxyController.transformOperation(context, operation);
                ModelNode transformedOperation = result.getTransformedOperation();
                final OperationResultTransformer resultTransformer = result.getResultTransformer();
                if (transformedOperation != null) {
                    ProxyController.ProxyOperationControl transformingProxyControl = new ProxyController.ProxyOperationControl(){

                        @Override
                        public void operationFailed(ModelNode response) {
                            ModelNode transformed;
                            if (result.rejectOperation(response)) {
                                ModelNode newResponse = new ModelNode();
                                newResponse.get("outcome").set("failed");
                                newResponse.get("failure-description").set(result.getFailureDescription());
                                transformed = newResponse;
                            } else {
                                transformed = response;
                            }
                            ModelNode result2 = resultTransformer.transformResult(transformed);
                            proxyControl.operationFailed(result2);
                        }

                        @Override
                        public void operationCompleted(final OperationResponse response) {
                            final ModelNode result2 = resultTransformer.transformResult(response.getResponseNode());
                            proxyControl.operationCompleted(new OperationResponse(){

                                public ModelNode getResponseNode() {
                                    return result2;
                                }

                                public List<OperationResponse.StreamEntry> getInputStreams() {
                                    return response.getInputStreams();
                                }

                                public OperationResponse.StreamEntry getInputStream(String uuid) {
                                    return response.getInputStream(uuid);
                                }

                                public void close() throws IOException {
                                    response.close();
                                }
                            });
                        }

                        @Override
                        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode response) {
                            ModelNode transformed;
                            if (result.rejectOperation(response)) {
                                ModelNode newResponse = new ModelNode();
                                newResponse.get("outcome").set("failed");
                                newResponse.get("failure-description").set(result.getFailureDescription());
                                transformed = newResponse;
                            } else {
                                transformed = response;
                            }
                            proxyControl.operationPrepared(transaction, transformed);
                        }
                    };
                    this.proxyController.execute(transformedOperation, messageHandler, transformingProxyControl, new DelegatingOperationAttachments(context));
                    break block8;
                } else {
                    ModelNode transformedResult = resultTransformer.transformResult(new ModelNode());
                    if (transformedResult != null) {
                        context.getResult().set(transformedResult);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                    return;
                }
            }
            this.proxyController.execute(operation, messageHandler, proxyControl, new DelegatingOperationAttachments(context));
        }
        OperationResponse finalResult = (OperationResponse)finalResultRef.get();
        if (finalResult == null) {
            this.completeRemoteTransaction(context, operation, txRef, preparedResultRef, finalResultRef);
            return;
        }
        ModelNode responseNode = finalResult.getResponseNode();
        ControllerLogger.MGMT_OP_LOGGER.tracef("Remote operation %s failed before commit with response %s", operation, responseNode);
        context.getResult().set(responseNode.get("result"));
        ModelNode failureDesc = responseNode.get("failure-description");
        RuntimeException stdFailure = ProxyStepHandler.translateFailureDescription(failureDesc);
        if (stdFailure != null) {
            ControllerLogger.MGMT_OP_LOGGER.tracef("Converted failure response to %s", stdFailure);
            throw stdFailure;
        }
        context.getFailureDescription().set(failureDesc);
        if (responseNode.hasDefined("response-headers")) {
            context.getResponseHeaders().set(responseNode.get("response-headers"));
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRemoteTransaction(OperationContext context, ModelNode operation, final AtomicReference<ModelController.OperationTransaction> txRef, AtomicReference<ModelNode> preparedResultRef, final AtomicReference<OperationResponse> finalResultRef) {
        boolean completeStepCalled = false;
        try {
            ModelNode preparedResponse = preparedResultRef.get();
            ModelNode preparedResult = preparedResponse.get("result");
            if (preparedResponse.hasDefined("failure-description")) {
                context.getFailureDescription().set(preparedResponse.get("failure-description"));
                if (preparedResult.isDefined()) {
                    context.getResult().set(preparedResult);
                }
            } else {
                context.getResult().set(preparedResult);
            }
            context.completeStep(new OperationContext.ResultHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    boolean txCompleted = false;
                    try {
                        ModelController.OperationTransaction tx = (ModelController.OperationTransaction)txRef.get();
                        try {
                            if (resultAction == OperationContext.ResultAction.KEEP) {
                                tx.commit();
                            } else {
                                tx.rollback();
                            }
                        }
                        finally {
                            txCompleted = true;
                        }
                        OperationResponse finalResponse = (OperationResponse)finalResultRef.get();
                        if (finalResponse != null) {
                            ModelNode responseNode = finalResponse.getResponseNode();
                            ModelNode finalResult = responseNode.get("result");
                            if (responseNode.hasDefined("failure-description")) {
                                context.getFailureDescription().set(responseNode.get("failure-description"));
                                if (finalResult.isDefined()) {
                                    context.getResult().set(finalResult);
                                }
                            } else {
                                context.getResult().set(finalResult);
                            }
                            if (context.getProcessType() == ProcessType.HOST_CONTROLLER && responseNode.has("server-groups")) {
                                context.getServerResults().set(responseNode.get("server-groups"));
                            }
                            if (responseNode.hasDefined("response-headers")) {
                                context.getResponseHeaders().set(ProxyStepHandler.this.processResponseHeaders(responseNode.get("response-headers")));
                            }
                            ResponseAttachmentInputStreamSupport.handleDomainOperationResponseStreams(context, responseNode, finalResponse.getInputStreams());
                        } else {
                            ControllerLogger.MGMT_OP_LOGGER.noFinalProxyOutcomeReceived(operation.get("operation"), operation.get("address"), ProxyStepHandler.this.proxyController.getProxyNodeAddress().toModelNode());
                        }
                    }
                    finally {
                        if (!txCompleted && txRef.get() != null) {
                            ((ModelController.OperationTransaction)txRef.get()).rollback();
                        }
                    }
                }
            });
            completeStepCalled = true;
        }
        finally {
            if (!completeStepCalled && txRef.get() != null) {
                txRef.get().rollback();
            }
        }
    }

    private ModelNode processResponseHeaders(ModelNode responseHeaders) {
        if (!responseHeaders.hasDefined("access-control") || !this.forServer) {
            return responseHeaders;
        }
        ModelNode result = responseHeaders.clone();
        for (ModelNode accItem : result.get("access-control").asList()) {
            ModelNode itemAddrNode = accItem.get("absolute-address");
            PathAddress itemAddr = PathAddress.pathAddress(itemAddrNode);
            itemAddrNode.set(this.proxyController.getProxyNodeAddress().append(itemAddr).toModelNode());
        }
        return result;
    }

    private boolean isWFCORE621Needed(ModelNode operation, PathAddress address) {
        String opName;
        if (this.proxyController.getKernelModelVersion().getMajor() < 3 && address.size() > 1 && ("read-resource".equals(opName = operation.get("operation").asString()) || "read-attribute".equals(opName) || "query".equals(opName) || "read-resource-description".equals(opName) && address.size() >= 2)) {
            PathElement pe = address.getElement(1);
            return pe.isMultiTarget() && "server".equals(pe.getKey());
        }
        return false;
    }

    private void executeWFCORE621(OperationContext context, ModelNode operation) throws OperationFailedException {
        OperationStepHandler osh = context.getRootResourceRegistration().getOperationHandler(PathAddress.EMPTY_ADDRESS, operation.get("operation").asString());
        osh.execute(context, operation);
    }

    private static RuntimeException translateFailureDescription(ModelNode failureDescription) {
        String failureDesc = failureDescription.asString();
        if (failureDesc.startsWith("WFLYCTL0216")) {
            return new Resource.NoSuchResourceException(failureDesc);
        }
        if (failureDesc.startsWith("WFLYCTL0313")) {
            return new UnauthorizedException(failureDesc);
        }
        return null;
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public boolean isAutoCloseStreams() {
            return false;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }

        public void close() throws IOException {
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }
}

