/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.replication;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.replication.ReplicationManager;

public class ReplicatedJournal
implements Journal {
    private static final boolean trace = false;
    private final ReplicationManager replicationManager;
    private final Journal localJournal;
    private final byte journalID;

    private static void trace(String message) {
        System.out.println("ReplicatedJournal::" + message);
    }

    public ReplicatedJournal(byte journalID, Journal localJournal, ReplicationManager replicationManager) {
        this.journalID = journalID;
        this.localJournal = localJournal;
        this.replicationManager = replicationManager;
    }

    @Override
    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, id, recordType, record);
        this.localJournal.appendAddRecord(id, recordType, record, sync);
    }

    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, id, recordType, record);
        this.localJournal.appendAddRecord(id, recordType, record, sync, completionCallback);
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.replicationManager.appendAddRecordTransactional(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, txID, id, recordType, record);
        this.localJournal.appendAddRecordTransactional(txID, id, recordType, record);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, true);
        this.localJournal.appendCommitRecord(txID, sync);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, true);
        this.localJournal.appendCommitRecord(txID, sync, callback);
    }

    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, lineUpContext);
        this.localJournal.appendCommitRecord(txID, sync, callback, lineUpContext);
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync);
    }

    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion completionCallback) throws Exception {
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync, completionCallback);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, new ByteArrayEncoding(record));
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id, record);
        this.localJournal.appendDeleteRecordTransactional(txID, id, record);
    }

    @Override
    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id);
        this.localJournal.appendDeleteRecordTransactional(txID, id);
    }

    @Override
    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.appendPrepareRecord(txID, new ByteArrayEncoding(transactionData), sync);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync);
    }

    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync, callback);
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync);
    }

    @Override
    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync, callback);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, new ByteArrayEncoding(record), sync);
    }

    @Override
    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, recordType, record);
        this.localJournal.appendUpdateRecord(id, recordType, record, sync);
    }

    @Override
    public void appendUpdateRecord(long id, byte journalRecordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, journalRecordType, record);
        this.localJournal.appendUpdateRecord(id, journalRecordType, record, sync, completionCallback);
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, new ByteArrayEncoding(record));
    }

    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.replicationManager.appendAddRecordTransactional(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, txID, id, recordType, record);
        this.localJournal.appendUpdateRecordTransactional(txID, id, recordType, record);
    }

    @Override
    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        return this.localJournal.load(committedRecords, preparedTransactions, transactionFailure);
    }

    @Override
    public JournalLoadInformation load(LoaderCallback reloadManager) throws Exception {
        return this.localJournal.load(reloadManager);
    }

    @Override
    public void perfBlast(int pages) {
        this.localJournal.perfBlast(pages);
    }

    @Override
    public void start() throws Exception {
        this.localJournal.start();
    }

    @Override
    public void stop() throws Exception {
        this.localJournal.stop();
    }

    @Override
    public int getAlignment() throws Exception {
        return this.localJournal.getAlignment();
    }

    @Override
    public boolean isStarted() {
        return this.localJournal.isStarted();
    }

    @Override
    public JournalLoadInformation loadInternalOnly() throws Exception {
        return this.localJournal.loadInternalOnly();
    }

    @Override
    public int getNumberOfRecords() {
        return this.localJournal.getNumberOfRecords();
    }

    @Override
    public void runDirectJournalBlast() throws Exception {
        this.localJournal.runDirectJournalBlast();
    }

    @Override
    public int getUserVersion() {
        return this.localJournal.getUserVersion();
    }

    @Override
    public void lineUpContext(IOCompletion callback) {
        ((OperationContext)callback).replicationLineUp();
        this.localJournal.lineUpContext(callback);
    }

    @Override
    public JournalLoadInformation loadSyncOnly(Journal.JournalState state) throws Exception {
        return this.localJournal.loadSyncOnly(state);
    }

    @Override
    public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        throw new UnsupportedOperationException("This method should only be called at a replicating backup");
    }

    @Override
    public void synchronizationLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void synchronizationUnlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceMoveNextFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JournalFile[] getDataFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SequentialFileFactory getFileFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFileSize() {
        return this.localJournal.getFileSize();
    }

    @Override
    public void scheduleCompactAndBlock(int timeout) throws Exception {
        this.localJournal.scheduleCompactAndBlock(timeout);
    }

    @Override
    public void replicationSyncPreserveOldFiles() {
        throw new UnsupportedOperationException("should never get called");
    }

    @Override
    public void replicationSyncFinished() {
        throw new UnsupportedOperationException("should never get called");
    }
}

