/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.io.StringReader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.ParseException;
import org.apache.james.mime4j.field.ParsedField;
import org.apache.james.mime4j.field.contentdisposition.parser.ContentDispositionParser;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.apache.james.mime4j.field.datetime.parser.TokenMgrError;
import org.apache.james.mime4j.util.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDispositionField
extends AbstractField {
    private static Log log = LogFactory.getLog(ContentDispositionField.class);
    public static final String DISPOSITION_TYPE_INLINE = "inline";
    public static final String DISPOSITION_TYPE_ATTACHMENT = "attachment";
    public static final String PARAM_FILENAME = "filename";
    public static final String PARAM_CREATION_DATE = "creation-date";
    public static final String PARAM_MODIFICATION_DATE = "modification-date";
    public static final String PARAM_READ_DATE = "read-date";
    public static final String PARAM_SIZE = "size";
    private boolean parsed = false;
    private String dispositionType = "";
    private Map<String, String> parameters = new HashMap<String, String>();
    private ParseException parseException;
    private boolean creationDateParsed;
    private Date creationDate;
    private boolean modificationDateParsed;
    private Date modificationDate;
    private boolean readDateParsed;
    private Date readDate;
    static final FieldParser PARSER = new FieldParser(){

        public ParsedField parse(String name, String body, ByteSequence raw) {
            return new ContentDispositionField(name, body, raw);
        }
    };

    ContentDispositionField(String name, String body, ByteSequence raw) {
        super(name, body, raw);
    }

    @Override
    public ParseException getParseException() {
        if (!this.parsed) {
            this.parse();
        }
        return this.parseException;
    }

    public String getDispositionType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType;
    }

    public String getParameter(String name) {
        if (!this.parsed) {
            this.parse();
        }
        return this.parameters.get(name.toLowerCase());
    }

    public Map<String, String> getParameters() {
        if (!this.parsed) {
            this.parse();
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isDispositionType(String dispositionType) {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType.equalsIgnoreCase(dispositionType);
    }

    public boolean isInline() {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType.equals(DISPOSITION_TYPE_INLINE);
    }

    public boolean isAttachment() {
        if (!this.parsed) {
            this.parse();
        }
        return this.dispositionType.equals(DISPOSITION_TYPE_ATTACHMENT);
    }

    public String getFilename() {
        return this.getParameter(PARAM_FILENAME);
    }

    public Date getCreationDate() {
        if (!this.creationDateParsed) {
            this.creationDate = this.parseDate(PARAM_CREATION_DATE);
            this.creationDateParsed = true;
        }
        return this.creationDate;
    }

    public Date getModificationDate() {
        if (!this.modificationDateParsed) {
            this.modificationDate = this.parseDate(PARAM_MODIFICATION_DATE);
            this.modificationDateParsed = true;
        }
        return this.modificationDate;
    }

    public Date getReadDate() {
        if (!this.readDateParsed) {
            this.readDate = this.parseDate(PARAM_READ_DATE);
            this.readDateParsed = true;
        }
        return this.readDate;
    }

    public long getSize() {
        String value = this.getParameter(PARAM_SIZE);
        if (value == null) {
            return -1L;
        }
        try {
            long size = Long.parseLong(value);
            return size < 0L ? -1L : size;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private Date parseDate(String paramName) {
        String value = this.getParameter(paramName);
        if (value == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing " + paramName + " null"));
            }
            return null;
        }
        try {
            return new DateTimeParser(new StringReader(value)).parseAll().getDate();
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing " + paramName + " '" + value + "': " + e.getMessage()));
            }
            return null;
        }
        catch (TokenMgrError e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing " + paramName + " '" + value + "': " + e.getMessage()));
            }
            return null;
        }
    }

    private void parse() {
        String body = this.getBody();
        ContentDispositionParser parser = new ContentDispositionParser(new StringReader(body));
        try {
            parser.parseAll();
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
            }
            this.parseException = e;
        }
        catch (org.apache.james.mime4j.field.contentdisposition.parser.TokenMgrError e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
            }
            this.parseException = new ParseException(e.getMessage());
        }
        String dispositionType = parser.getDispositionType();
        if (dispositionType != null) {
            this.dispositionType = dispositionType.toLowerCase(Locale.US);
            List<String> paramNames = parser.getParamNames();
            List<String> paramValues = parser.getParamValues();
            if (paramNames != null && paramValues != null) {
                int len = Math.min(paramNames.size(), paramValues.size());
                for (int i = 0; i < len; ++i) {
                    String paramName = paramNames.get(i).toLowerCase(Locale.US);
                    String paramValue = paramValues.get(i);
                    this.parameters.put(paramName, paramValue);
                }
            }
        }
        this.parsed = true;
    }
}

