/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.jboss.as.clustering.infinispan.subsystem.RestartableServiceHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class RestartCacheWriteAttributeHandler
extends RestartParentWriteAttributeHandler {
    private final RestartableServiceHandler serviceInstaller;

    public RestartCacheWriteAttributeHandler(String parentKeyName, RestartableServiceHandler serviceInstaller, AttributeDefinition ... definitions) {
        super(parentKeyName, definitions);
        this.serviceInstaller = serviceInstaller;
    }

    protected void recreateParentService(OperationContext context, PathAddress cacheAddress, ModelNode cacheModel) throws OperationFailedException {
        this.recreateParentService(context, cacheAddress, cacheModel, null);
    }

    protected void recreateParentService(OperationContext context, PathAddress cacheAddress, ModelNode cacheModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        ModelNode operation = Util.createAddOperation((PathAddress)cacheAddress);
        this.serviceInstaller.installRuntimeServices(context, operation, containerModel, cacheModel);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        int position = parentAddress.size();
        PathAddress cacheAddress = parentAddress.subAddress(position - 1);
        PathAddress containerAddress = parentAddress.subAddress(position - 2, position - 1);
        return CacheServiceName.CACHE.getServiceName(containerAddress.getLastElement().getValue(), cacheAddress.getLastElement().getValue());
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        super.removeServices(context, parentService, parentModel);
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return true;
    }
}

