/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra;

import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.AdminObjectReferenceFactoryService;
import org.jboss.as.connector.services.resourceadapters.DirectAdminObjectActivatorService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class AdministeredObjectDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    public static final String DESCRIPTION = "description";
    public static final String INTERFACE = "interfaceName";
    public static final String PROPERTIES = "properties";
    private final String className;
    private final String resourceAdapter;
    private String description;
    private String interfaceName;

    public AdministeredObjectDefinitionInjectionSource(String jndiName, String className, String resourceAdapter) {
        super(jndiName);
        this.className = className;
        this.resourceAdapter = resourceAdapter;
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        String raId = this.resourceAdapter;
        if (this.resourceAdapter.startsWith("#")) {
            raId = deploymentUnit.getParent().getName() + raId;
        }
        String deployerServiceName = raId;
        if (!raId.endsWith(".rar")) {
            raId = deployerServiceName = deployerServiceName + ".rar";
        }
        ConnectorLogger.SUBSYSTEM_RA_LOGGER.debugf("@AdministeredObjectDefinition: %s for %s binding to %s ", this.className, this.resourceAdapter, this.jndiName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)this.jndiName);
        DirectAdminObjectActivatorService service = new DirectAdminObjectActivatorService(this.jndiName, this.className, this.resourceAdapter, raId, this.properties, module, bindInfo);
        ServiceName serviceName = DirectAdminObjectActivatorService.SERVICE_NAME_BASE.append(new String[]{this.jndiName});
        phaseContext.getServiceTarget().addService(serviceName, (Service)service).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, service.getMdrInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{deployerServiceName})).setInitialMode(ServiceController.Mode.ACTIVE).install();
        serviceBuilder.addDependency(AdminObjectReferenceFactoryService.SERVICE_NAME_BASE.append(bindInfo.getBinderServiceName()), ManagedReferenceFactory.class, injector);
        serviceBuilder.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.adminObjectAnnotation(AdministeredObjectDefinitionInjectionSource.this.jndiName);
                        break;
                    }
                    case STOPPING_to_DOWN: {
                        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.unboundJca("AdminObject", AdministeredObjectDefinitionInjectionSource.this.jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Removed JCA AdminObject [%s]", AdministeredObjectDefinitionInjectionSource.this.jndiName);
                    }
                }
            }
        });
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public void setInterface(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdministeredObjectDefinitionInjectionSource that = (AdministeredObjectDefinitionInjectionSource)((Object)o);
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.interfaceName != null ? !this.interfaceName.equals(that.interfaceName) : that.interfaceName != null) {
            return false;
        }
        return !(this.resourceAdapter != null ? !this.resourceAdapter.equals(that.resourceAdapter) : that.resourceAdapter != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.resourceAdapter != null ? this.resourceAdapter.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.interfaceName != null ? this.interfaceName.hashCode() : 0);
        return result;
    }
}

