/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.cloner;

import java.io.IOException;
import java.lang.reflect.Proxy;
import org.jboss.marshalling.cloner.ClassCloner;

public class ClassLoaderClassCloner
implements ClassCloner {
    private final ClassLoader destClassLoader;

    public ClassLoaderClassCloner(ClassLoader destClassLoader) {
        this.destClassLoader = destClassLoader;
    }

    @Override
    public Class<?> clone(Class<?> original) throws IOException, ClassNotFoundException {
        if (original.isPrimitive()) {
            return original;
        }
        String name = original.getName();
        if (name.startsWith("java.")) {
            return original;
        }
        if (original.getClassLoader() == this.destClassLoader) {
            return original;
        }
        return Class.forName(name, true, this.destClassLoader);
    }

    @Override
    public Class<?> cloneProxy(Class<?> proxyClass) throws IOException, ClassNotFoundException {
        Class<?>[] origInterfaces = proxyClass.getInterfaces();
        Class[] interfaces = new Class[origInterfaces.length];
        int origInterfacesLength = origInterfaces.length;
        for (int i = 0; i < origInterfacesLength; ++i) {
            interfaces[i] = this.clone(origInterfaces[i]);
        }
        return Proxy.getProxyClass(this.destClassLoader, interfaces);
    }
}

