/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.operations.DomainOperationTransformer;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.HostControllerUpdateTask;
import org.jboss.as.domain.controller.operations.coordination.MultiphaseOverallContext;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class DomainSlaveHandler
implements OperationStepHandler {
    private final MultiphaseOverallContext multiphaseContext;
    private final Map<String, ProxyController> hostProxies;

    public DomainSlaveHandler(Map<String, ProxyController> hostProxies, MultiphaseOverallContext domainOperationContext) {
        this.hostProxies = hostProxies;
        this.multiphaseContext = domainOperationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.hasFailureDescription()) {
            context.setRollbackOnly();
            return;
        }
        HashSet<String> outstanding = new HashSet<String>(this.hostProxies.keySet());
        final ArrayList<TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>> results = new ArrayList<TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>>();
        final HashMap<String, HostControllerUpdateTask.ExecutedHostRequest> finalResults = new HashMap<String, HostControllerUpdateTask.ExecutedHostRequest>();
        HostControllerUpdateTask.ProxyOperationListener listener = new HostControllerUpdateTask.ProxyOperationListener();
        Transformers.TransformationInputs transformationInputs = Transformers.TransformationInputs.getOrCreate((OperationContext)context);
        for (Map.Entry<String, ProxyController> entry : this.hostProxies.entrySet()) {
            String host = entry.getKey();
            TransformingProxyController proxyController = (TransformingProxyController)entry.getValue();
            List list = (List)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS);
            ModelNode op = operation;
            if (list != null) {
                for (DomainOperationTransformer transformer : list) {
                    op = transformer.transform(context, op);
                    op.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
                }
            }
            ModelNode clonedOp = op.clone();
            clonedOp.get(new String[]{"operation-headers", "domain-controller-lock-id"}).set(CurrentOperationIdHolder.getCurrentOperationID().intValue());
            HostControllerUpdateTask task = new HostControllerUpdateTask(host, clonedOp, context, proxyController, transformationInputs);
            HostControllerUpdateTask.ExecutedHostRequest finalResult = task.execute(listener);
            this.multiphaseContext.recordHostRequest(host, finalResult);
            finalResults.put(host, finalResult);
        }
        boolean interrupted = false;
        boolean completeStepCalled = false;
        try {
            try {
                while (outstanding.size() > 0) {
                    TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation();
                    String hostName = ((HostControllerUpdateTask.ProxyOperation)prepared.getOperation()).getName();
                    if (!outstanding.remove(hostName)) continue;
                    ModelNode modelNode = prepared.getPreparedResult();
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Preliminary result for remote host %s is %s", hostName, modelNode);
                    HostControllerUpdateTask.ExecutedHostRequest request = (HostControllerUpdateTask.ExecutedHostRequest)finalResults.get(hostName);
                    boolean reject = request.rejectOperation(modelNode);
                    if (reject) {
                        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isDebugEnabled()) {
                            DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf("Rejecting result for remote host %s is %s", hostName, modelNode);
                        }
                        ModelNode failedResult = new ModelNode();
                        failedResult.get("outcome").set("failed");
                        failedResult.get("failure-description").set(request.getFailureDescription());
                        this.multiphaseContext.addHostControllerPreparedResult(hostName, failedResult);
                    } else {
                        this.multiphaseContext.addHostControllerPreparedResult(hostName, modelNode);
                    }
                    results.add((TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>)prepared);
                }
            }
            catch (InterruptedException ie) {
                interrupted = true;
                this.multiphaseContext.setFailureReported(true);
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingHostPreparedResponse(finalResults.keySet());
                for (HostControllerUpdateTask.ExecutedHostRequest executedHostRequest : finalResults.values()) {
                    executedHostRequest.asyncCancel();
                }
                for (Map.Entry entry : finalResults.entrySet()) {
                    ModelNode result;
                    String hostName = (String)entry.getKey();
                    try {
                        HostControllerUpdateTask.ExecutedHostRequest request = (HostControllerUpdateTask.ExecutedHostRequest)entry.getValue();
                        result = request.getFinalResult().get().getResponseNode();
                        ModelNode transformedResult = request.transformResult(result);
                        this.multiphaseContext.addHostControllerPreparedResult(hostName, transformedResult);
                    }
                    catch (Exception e) {
                        result = new ModelNode();
                        result.get("outcome").set("failed");
                        if (e instanceof InterruptedException) {
                            result.get("failure-description").set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingResultFromHost((String)entry.getKey()));
                            interrupted = true;
                        } else {
                            result.get("failure-description").set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.exceptionAwaitingResultFromHost((String)entry.getKey(), e.getMessage()));
                        }
                        this.multiphaseContext.addHostControllerPreparedResult(hostName, result);
                    }
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    DomainSlaveHandler.this.finalizeOp(results, finalResults, false, context);
                }
            });
            completeStepCalled = true;
        }
        finally {
            if (!completeStepCalled) {
                this.finalizeOp(results, finalResults, interrupted, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeOp(List<TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>> results, Map<String, HostControllerUpdateTask.ExecutedHostRequest> finalResults, boolean interrupted, OperationContext context) {
        boolean interruptThread = Thread.interrupted() || interrupted;
        try {
            boolean rollback = this.multiphaseContext.isCompleteRollback();
            for (TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation> prepared : results) {
                boolean bl = interruptThread = Thread.interrupted() || interruptThread;
                if (prepared.isDone()) continue;
                if (!rollback) {
                    prepared.commit();
                    continue;
                }
                prepared.rollback();
            }
            int patient = interruptThread ? 50 : -1;
            for (TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation> prepared : results) {
                String hostName = ((HostControllerUpdateTask.ProxyOperation)prepared.getOperation()).getName();
                HostControllerUpdateTask.ExecutedHostRequest request = finalResults.get(hostName);
                AsyncFuture future = prepared.getFinalResult();
                try {
                    OperationResponse finalResponse = patient < 0 ? (OperationResponse)future.get() : (OperationResponse)future.get(patient, TimeUnit.MILLISECONDS);
                    ModelNode transformedResult = request.transformResult(finalResponse.getResponseNode());
                    this.multiphaseContext.addHostControllerFinalResult(hostName, transformedResult);
                    ResponseAttachmentInputStreamSupport.handleDomainOperationResponseStreams((OperationContext)context, (ModelNode)transformedResult, (List)finalResponse.getInputStreams());
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Final result for remote host %s is %s", hostName, finalResponse.getResponseNode());
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Transformed result from host %s is %s", hostName, transformedResult);
                }
                catch (InterruptedException e) {
                    interruptThread = true;
                    future.cancel(true);
                    patient = patient == 0 ? 0 : 50;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(hostName);
                }
                catch (ExecutionException e) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), hostName);
                }
                catch (TimeoutException e) {
                    future.cancel(true);
                    patient = 0;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(hostName);
                }
            }
        }
        finally {
            if (interruptThread) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

