/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAConnection;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionRequestInfo;
import org.apache.activemq.artemis.ra.ActiveMQRACredential;
import org.apache.activemq.artemis.ra.ActiveMQRALocalTransaction;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAMetaData;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.apache.activemq.artemis.ra.ActiveMQRAXAResource;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.utils.VersionLoader;

public final class ActiveMQRAManagedConnection
implements ManagedConnection,
ExceptionListener {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    private final ActiveMQRAManagedConnectionFactory mcf;
    private final ActiveMQRAConnectionRequestInfo cri;
    private final ActiveMQResourceAdapter ra;
    private final String userName;
    private final String password;
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final List<ConnectionEventListener> eventListeners;
    private final Set<ActiveMQRASession> handles;
    private ReentrantLock lock = new ReentrantLock();
    private ActiveMQConnectionFactory connectionFactory;
    private ActiveMQXAConnection connection;
    private Session nonXAsession;
    private XASession xaSession;
    private XAResource xaResource;
    private final TransactionManager tm;
    private boolean inManagedTx;

    public ActiveMQRAManagedConnection(ActiveMQRAManagedConnectionFactory mcf, ActiveMQRAConnectionRequestInfo cri, ActiveMQResourceAdapter ra, String userName, String password) throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + mcf + ", " + cri + ", " + userName + ", ****)");
        }
        this.mcf = mcf;
        this.cri = cri;
        this.tm = ra.getTM();
        this.ra = ra;
        this.userName = userName;
        this.password = password;
        this.eventListeners = Collections.synchronizedList(new ArrayList());
        this.handles = Collections.synchronizedSet(new HashSet());
        this.connection = null;
        this.nonXAsession = null;
        this.xaSession = null;
        this.xaResource = null;
        try {
            this.setup();
        }
        catch (ResourceException e) {
            try {
                this.destroy();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable t) {
            try {
                this.destroy();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new ResourceException("Error during setup", t);
        }
    }

    public synchronized Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConnection(" + subject + ", " + cxRequestInfo + ")");
        }
        ActiveMQRACredential credential = ActiveMQRACredential.getCredential(this.mcf, subject, cxRequestInfo);
        if (this.userName != null && !this.userName.equals(credential.getUserName())) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (this.userName == null && credential.getUserName() != null) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (this.isDestroyed.get()) {
            throw new javax.resource.spi.IllegalStateException("The managed connection is already destroyed");
        }
        ActiveMQRASession session = new ActiveMQRASession(this, (ActiveMQRAConnectionRequestInfo)cxRequestInfo);
        this.handles.add(session);
        return session;
    }

    private void destroyHandles() throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("destroyHandles()");
        }
        try {
            if (this.connection != null) {
                this.connection.stop();
            }
        }
        catch (Throwable t) {
            ActiveMQRALogger.LOGGER.trace("Ignored error stopping connection", t);
        }
        for (ActiveMQRASession session : this.handles) {
            session.destroy();
        }
        this.handles.clear();
    }

    public void destroy() throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("destroy()");
        }
        if (this.isDestroyed.get() || this.connection == null) {
            return;
        }
        this.isDestroyed.set(true);
        try {
            this.connection.setExceptionListener(null);
        }
        catch (JMSException e) {
            ActiveMQRALogger.LOGGER.debug("Error unsetting the exception listener " + this, e);
        }
        if (this.connection != null) {
            this.connection.signalStopToAllSessions();
        }
        this.destroyHandles();
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            try {
                if (this.nonXAsession != null) {
                    this.nonXAsession.close();
                }
                if (this.xaSession != null) {
                    this.xaSession.close();
                }
            }
            catch (JMSException e) {
                ActiveMQRALogger.LOGGER.debug("Error closing session " + this, e);
            }
            if (this.connectionFactory != null) {
                this.ra.closeConnectionFactory(this.mcf.getProperties());
            }
        }
        catch (Throwable e) {
            throw new ResourceException("Could not properly close the session and connection", e);
        }
    }

    public void cleanup() throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("cleanup()");
        }
        if (this.isDestroyed.get()) {
            throw new javax.resource.spi.IllegalStateException("ManagedConnection already destroyed");
        }
        this.destroyHandles();
        this.inManagedTx = false;
        this.inManagedTx = false;
        this.lock = new ReentrantLock();
    }

    public void associateConnection(Object obj) throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("associateConnection(" + obj + ")");
        }
        if (this.isDestroyed.get() || !(obj instanceof ActiveMQRASession)) {
            throw new javax.resource.spi.IllegalStateException("ManagedConnection in an illegal state");
        }
        ActiveMQRASession h = (ActiveMQRASession)obj;
        h.setManagedConnection(this);
        this.handles.add(h);
    }

    public void checkTransactionActive() throws JMSException {
        if (!this.inManagedTx && this.tm != null) {
            try {
                int status;
                Transaction tx = this.tm.getTransaction();
                if (tx != null && (status = tx.getStatus()) != 0 && status != 7 && status != 2 && status != 8) {
                    throw new IllegalStateException("Transaction " + tx + " not active");
                }
            }
            catch (SystemException e) {
                IllegalStateException jmsE = new IllegalStateException("Unexpected exception on the Transaction ManagerTransaction");
                jmsE.initCause((Throwable)e);
                throw jmsE;
            }
        }
    }

    protected void lock() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("lock()");
        }
        this.lock.lock();
    }

    protected void tryLock() throws JMSException {
        Integer tryLock;
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("tryLock()");
        }
        if ((tryLock = this.mcf.getUseTryLock()) == null || tryLock <= 0) {
            this.lock();
            return;
        }
        try {
            if (!this.lock.tryLock(tryLock.intValue(), TimeUnit.SECONDS)) {
                throw new ResourceAllocationException("Unable to obtain lock in " + tryLock + " seconds: " + this);
            }
        }
        catch (InterruptedException e) {
            throw new ResourceAllocationException("Interrupted attempting lock: " + this);
        }
    }

    protected void unlock() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("unlock()");
        }
        this.lock.unlock();
    }

    public void addConnectionEventListener(ConnectionEventListener l) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("addConnectionEventListener(" + l + ")");
        }
        this.eventListeners.add(l);
    }

    public void removeConnectionEventListener(ConnectionEventListener l) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("removeConnectionEventListener(" + l + ")");
        }
        this.eventListeners.remove(l);
    }

    public XAResource getXAResource() throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getXAResource()");
        }
        if (this.xaResource == null) {
            ClientSessionInternal csi = (ClientSessionInternal)this.xaSession.getXAResource();
            ActiveMQRAXAResource activeMQRAXAResource = new ActiveMQRAXAResource(this, this.xaSession.getXAResource());
            HashMap<String, String> xaResourceProperties = new HashMap<String, String>();
            xaResourceProperties.put("ACTIVEMQ_JNDI_ID", this.ra.getJndiName());
            xaResourceProperties.put("ACTIVEMQ_NODE_ID", csi.getNodeId());
            xaResourceProperties.put("ACTIVEMQ_PRODUCT_NAME", "ActiveMQ Artemis");
            xaResourceProperties.put("ACTIVEMQ_PRODUCT_VERSION", VersionLoader.getVersion().getFullVersion());
            this.xaResource = ServiceUtils.wrapXAResource((XAResource)((Object)activeMQRAXAResource), xaResourceProperties);
        }
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("XAResource=" + this.xaResource);
        }
        return this.xaResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getLocalTransaction()");
        }
        ActiveMQRALocalTransaction tx = new ActiveMQRALocalTransaction(this);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("LocalTransaction=" + tx);
        }
        return tx;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMetaData()");
        }
        if (this.isDestroyed.get()) {
            throw new javax.resource.spi.IllegalStateException("The managed connection is already destroyed");
        }
        return new ActiveMQRAMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setLogWriter(" + out + ")");
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getLogWriter()");
        }
        return null;
    }

    public void onException(JMSException exception) {
        if ("FAILOVER".equals(exception.getErrorCode())) {
            return;
        }
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("onException(" + (Object)((Object)exception) + ")");
        }
        if (this.isDestroyed.get()) {
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("Ignoring error on already destroyed connection " + this, exception);
            }
            return;
        }
        ActiveMQRALogger.LOGGER.handlingJMSFailure((Exception)((Object)exception));
        try {
            this.connection.setExceptionListener(null);
        }
        catch (JMSException e) {
            ActiveMQRALogger.LOGGER.debug("Unable to unset exception listener", e);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, (Exception)((Object)exception));
        this.sendEvent(event);
    }

    protected Session getSession() throws JMSException {
        if (this.xaResource != null && this.inManagedTx) {
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("getSession() -> XA session " + this.xaSession.getSession());
            }
            return this.xaSession.getSession();
        }
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getSession() -> non XA session " + this.nonXAsession);
        }
        return this.nonXAsession;
    }

    protected void sendEvent(ConnectionEvent event) {
        ConnectionEventListener[] list;
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("sendEvent(" + event + ")");
        }
        int type = event.getId();
        block7: for (ConnectionEventListener l : list = this.eventListeners.toArray(new ConnectionEventListener[this.eventListeners.size()])) {
            switch (type) {
                case 1: {
                    l.connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    l.localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    l.localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    l.localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    l.connectionErrorOccurred(event);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + type);
                }
            }
        }
    }

    protected void removeHandle(ActiveMQRASession handle) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("removeHandle(" + handle + ")");
        }
        this.handles.remove(handle);
    }

    protected ActiveMQRAConnectionRequestInfo getCRI() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getCRI()");
        }
        return this.cri;
    }

    protected ActiveMQRAManagedConnectionFactory getManagedConnectionFactory() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getManagedConnectionFactory()");
        }
        return this.mcf;
    }

    void start() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("start()");
        }
        if (this.connection != null) {
            this.connection.start();
        }
    }

    void stop() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("stop()");
        }
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    protected String getUserName() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getUserName()");
        }
        return this.userName;
    }

    private void setup() throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setup()");
        }
        try {
            this.createCF();
            boolean transacted = this.cri.isTransacted();
            int acknowledgeMode = 1;
            if (this.cri.getType() == 2) {
                this.connection = this.userName != null && this.password != null ? (ActiveMQXAConnection)this.connectionFactory.createXATopicConnection(this.userName, this.password) : (ActiveMQXAConnection)this.connectionFactory.createXATopicConnection();
                this.connection.setExceptionListener((ExceptionListener)this);
                this.xaSession = this.connection.createXATopicSession();
                this.nonXAsession = this.connection.createNonXATopicSession(transacted, acknowledgeMode);
            } else if (this.cri.getType() == 1) {
                this.connection = this.userName != null && this.password != null ? (ActiveMQXAConnection)this.connectionFactory.createXAQueueConnection(this.userName, this.password) : (ActiveMQXAConnection)this.connectionFactory.createXAQueueConnection();
                this.connection.setExceptionListener((ExceptionListener)this);
                this.xaSession = this.connection.createXAQueueSession();
                this.nonXAsession = this.connection.createNonXAQueueSession(transacted, acknowledgeMode);
            } else {
                this.connection = this.userName != null && this.password != null ? (ActiveMQXAConnection)this.connectionFactory.createXAConnection(this.userName, this.password) : (ActiveMQXAConnection)this.connectionFactory.createXAConnection();
                this.connection.setExceptionListener((ExceptionListener)this);
                this.xaSession = this.connection.createXASession();
                this.nonXAsession = this.connection.createNonXASession(transacted, acknowledgeMode);
            }
        }
        catch (JMSException je) {
            throw new ResourceException(je.getMessage(), (Throwable)je);
        }
    }

    private void createCF() {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.ra.createActiveMQConnectionFactory(this.mcf.getProperties());
        }
    }

    protected void setInManagedTx(boolean inManagedTx) {
        this.inManagedTx = inManagedTx;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

