/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.SharedStoreBackupActivation;

public class SharedStoreSlavePolicy
extends BackupPolicy {
    private long failbackDelay = ActiveMQDefaultConfiguration.getDefaultFailbackDelay();
    private boolean failoverOnServerShutdown = ActiveMQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private boolean allowAutoFailBack = ActiveMQDefaultConfiguration.isDefaultAllowAutoFailback();
    private SharedStoreMasterPolicy sharedStoreMasterPolicy;

    public SharedStoreSlavePolicy() {
    }

    public SharedStoreSlavePolicy(long failbackDelay, boolean failoverOnServerShutdown, boolean restartBackup, boolean allowAutoFailBack, ScaleDownPolicy scaleDownPolicy) {
        this.failbackDelay = failbackDelay;
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.restartBackup = restartBackup;
        this.allowAutoFailBack = allowAutoFailBack;
        this.scaleDownPolicy = scaleDownPolicy;
    }

    public long getFailbackDelay() {
        return this.failbackDelay;
    }

    public void setFailbackDelay(long failbackDelay) {
        this.failbackDelay = failbackDelay;
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    public SharedStoreMasterPolicy getSharedStoreMasterPolicy() {
        if (this.sharedStoreMasterPolicy == null) {
            this.sharedStoreMasterPolicy = new SharedStoreMasterPolicy(this.failbackDelay, this.failoverOnServerShutdown);
        }
        return this.sharedStoreMasterPolicy;
    }

    public void setSharedStoreMasterPolicy(SharedStoreMasterPolicy sharedStoreMasterPolicy) {
        this.sharedStoreMasterPolicy = sharedStoreMasterPolicy;
    }

    @Override
    public boolean isSharedStore() {
        return true;
    }

    @Override
    public boolean canScaleDown() {
        return this.scaleDownPolicy != null;
    }

    public boolean isAllowAutoFailBack() {
        return this.allowAutoFailBack;
    }

    public void setAllowAutoFailBack(boolean allowAutoFailBack) {
        this.allowAutoFailBack = allowAutoFailBack;
    }

    @Override
    public Activation createActivation(ActiveMQServerImpl server, boolean wasLive, Map<String, Object> activationParams, ActiveMQServerImpl.ShutdownOnCriticalErrorListener shutdownOnCriticalIO) {
        return new SharedStoreBackupActivation(server, this);
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }
}

