/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.hql.FilterProcessingChain;
import org.infinispan.objectfilter.impl.hql.RowPropertyHelper;
import org.infinispan.objectfilter.impl.predicateindex.RowMatcherEvalContext;

public final class RowMatcher
extends BaseMatcher<RowPropertyHelper.RowMetadata, RowPropertyHelper.ColumnMetadata, Integer> {
    private final RowPropertyHelper.RowMetadata rowMetadata;
    private final RowPropertyHelper propertyHelper;
    private final EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

        public Class<?> getClassFromName(String entityName) {
            return Object[].class;
        }
    };

    public RowMatcher(RowPropertyHelper.ColumnMetadata[] columns) {
        this.rowMetadata = new RowPropertyHelper.RowMetadata(columns);
        this.propertyHelper = new RowPropertyHelper(this.rowMetadata);
    }

    protected RowMatcherEvalContext startMultiTypeContext(Object userContext, Object eventType, Object instance) {
        FilterRegistry<RowPropertyHelper.RowMetadata, RowPropertyHelper.ColumnMetadata, Integer> filterRegistry = this.getFilterRegistryForType(this.rowMetadata);
        if (filterRegistry != null) {
            RowMatcherEvalContext context = new RowMatcherEvalContext(userContext, eventType, instance, this.rowMetadata);
            context.initMultiFilterContext(filterRegistry);
            return context;
        }
        return null;
    }

    protected RowMatcherEvalContext startSingleTypeContext(Object userContext, Object eventType, Object instance, MetadataAdapter<RowPropertyHelper.RowMetadata, RowPropertyHelper.ColumnMetadata, Integer> metadataAdapter) {
        if (Object[].class == instance.getClass()) {
            return new RowMatcherEvalContext(userContext, eventType, instance, this.rowMetadata);
        }
        return null;
    }

    @Override
    protected FilterProcessingChain<RowPropertyHelper.RowMetadata> createFilterProcessingChain(Map<String, Object> namedParameters) {
        return FilterProcessingChain.build(this.entityNamesResolver, this.propertyHelper, namedParameters);
    }

    @Override
    protected FilterRegistry<RowPropertyHelper.RowMetadata, RowPropertyHelper.ColumnMetadata, Integer> getFilterRegistryForType(RowPropertyHelper.RowMetadata entityType) {
        return (FilterRegistry)this.filtersByType.get(entityType);
    }

    public RowPropertyHelper getPropertyHelper() {
        return this.propertyHelper;
    }

    @Override
    protected MetadataAdapter<RowPropertyHelper.RowMetadata, RowPropertyHelper.ColumnMetadata, Integer> createMetadataAdapter(RowPropertyHelper.RowMetadata rowMetadata) {
        return new MetadataAdapterImpl(rowMetadata);
    }

    private static class MetadataAdapterImpl
    implements MetadataAdapter<RowPropertyHelper.RowMetadata, RowPropertyHelper.ColumnMetadata, Integer> {
        private final RowPropertyHelper.RowMetadata rowMetadata;

        MetadataAdapterImpl(RowPropertyHelper.RowMetadata rowMetadata) {
            this.rowMetadata = rowMetadata;
        }

        @Override
        public String getTypeName() {
            return "Row";
        }

        @Override
        public RowPropertyHelper.RowMetadata getTypeMetadata() {
            return this.rowMetadata;
        }

        @Override
        public List<Integer> translatePropertyPath(List<String> path) {
            if (path.size() > 1) {
                throw new IllegalStateException("Nested attributes are not supported");
            }
            String columnName = path.get(0);
            for (RowPropertyHelper.ColumnMetadata c : this.rowMetadata.getColumns()) {
                if (!c.getColumnName().equals(columnName)) continue;
                return Collections.singletonList(c.getColumnIndex());
            }
            throw new IllegalArgumentException("Column not found : " + columnName);
        }

        @Override
        public RowPropertyHelper.ColumnMetadata makeChildAttributeMetadata(RowPropertyHelper.ColumnMetadata parentAttributeMetadata, Integer attribute) {
            if (parentAttributeMetadata != null) {
                throw new IllegalStateException("Nested attributes are not supported");
            }
            return this.rowMetadata.getColumns()[attribute];
        }

        @Override
        public boolean isComparableProperty(RowPropertyHelper.ColumnMetadata attributeMetadata) {
            Class<?> propertyType = attributeMetadata.getPropertyType();
            return propertyType.isPrimitive() || Comparable.class.isAssignableFrom(propertyType);
        }
    }
}

