/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.modcluster.ModClusterService;
import org.jboss.modcluster.config.ProxyConfiguration;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.mod_cluster.ModClusterLogger;

public class ContainerEventHandlerService
implements Service<ModClusterService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"modcluster"});
    public static final ServiceName CONFIG_SERVICE_NAME = SERVICE_NAME.append(new String[]{"config"});
    private LoadBalanceFactorProvider load;
    private ModClusterConfig config;
    private final Value<SocketBindingManager> bindingManager;
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private final Map<String, OutboundSocketBinding> outboundSocketBindings = new HashMap<String, OutboundSocketBinding>();
    private volatile ModClusterService eventHandler;

    ContainerEventHandlerService(ModClusterConfig config, LoadBalanceFactorProvider load, Value<SocketBindingManager> bindingManager) {
        this.config = config;
        this.load = load;
        this.bindingManager = bindingManager;
    }

    public ModClusterService getValue() throws IllegalStateException, IllegalArgumentException {
        return this.eventHandler;
    }

    public void start(StartContext context) {
        SocketBinding binding;
        ModClusterLogger.ROOT_LOGGER.debugf("Starting mod_cluster extension", new Object[0]);
        boolean isMulticast = this.isMulticastEnabled(((SocketBindingManager)this.bindingManager.getValue()).getDefaultInterfaceBinding().getNetworkInterfaces());
        if (this.outboundSocketBindings.size() > 0) {
            LinkedList<1> proxies = new LinkedList<1>();
            for (final OutboundSocketBinding binding2 : this.outboundSocketBindings.values()) {
                proxies.add(new ProxyConfiguration(){

                    public InetSocketAddress getRemoteAddress() {
                        return new InetSocketAddress(binding2.getUnresolvedDestinationAddress(), binding2.getDestinationPort());
                    }

                    public InetSocketAddress getLocalAddress() {
                        if (binding2.getOptionalSourceAddress() != null) {
                            return new InetSocketAddress(binding2.getOptionalSourceAddress(), binding2.getAbsoluteSourcePort() == null ? 0 : binding2.getAbsoluteSourcePort());
                        }
                        if (binding2.getAbsoluteSourcePort() != null) {
                            return new InetSocketAddress(binding2.getAbsoluteSourcePort());
                        }
                        return null;
                    }
                });
            }
            this.config.setProxyConfigurations(proxies);
        }
        if (this.config.getProxyConfigurations().isEmpty()) {
            this.config.setAdvertise(Boolean.valueOf(isMulticast));
        }
        if (this.config.getAdvertise().booleanValue() && (binding = (SocketBinding)this.binding.getOptionalValue()) != null) {
            this.config.setAdvertiseSocketAddress(binding.getMulticastSocketAddress());
            this.config.setAdvertiseInterface(binding.getSocketAddress().getAddress());
            if (!isMulticast) {
                ModClusterLogger.ROOT_LOGGER.multicastInterfaceNotAvailable();
            }
        }
        this.eventHandler = new ModClusterService(this.config, this.load);
    }

    private boolean isMulticastEnabled(Collection<NetworkInterface> ifaces) {
        for (NetworkInterface iface : ifaces) {
            try {
                if (!iface.isUp() || !iface.supportsMulticast() && !iface.isLoopback()) continue;
                return true;
            }
            catch (SocketException socketException) {
            }
        }
        return false;
    }

    public void stop(StopContext context) {
        this.eventHandler.shutdown();
        this.eventHandler = null;
    }

    Injector<SocketBinding> getSocketBindingInjector() {
        return this.binding;
    }

    Injector<OutboundSocketBinding> getOutboundSocketBindingInjector(String name) {
        return new MapInjector(this.outboundSocketBindings, (Object)name);
    }
}

