/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.util;

import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.jboss.security.xacml.jaxb.Option;
import org.picketbox.commons.cipher.PBEUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPCommon {
    private static Logger log = Logger.getLogger(LDAPCommon.class.getName());
    private static final String XACML_LDAP_URL = "url";
    private String url;
    private static final String XACML_LDAP_FACTORY = "factory";
    private String factory;
    private static final String XACML_LDAP_USERNAME = "username";
    private String username;
    private static final String XACML_LDAP_PASSWORD = "password";
    private String password;
    private static final String XACML_LDAP_FILTER = "filter";
    private String filter;
    private static final String XACML_LDAP_ATTRIBUTE = "attribute";
    private String attribute;
    private static final String XACML_LDAP_SEARCH_SCOPE = "searchScope";
    private int searchScope = 2;
    private static final String XACML_LDAP_SEARCH_TIMELIMIT = "searchTimeLimit";
    private int searchTimeLimit = 10000;
    private static final String XACML_LDAP_BASEDN = "baseDN";
    private String baseDN;
    private static final String XACML_LDAP_SALT = "salt";
    private String salt;
    private static final String XACML_LDAP_COUNT = "iterationCount";
    private int iterationCount;
    private static final String XACML_LDAP_PASSWORD_PREFIX = "MASK-";
    private static final String XACML_LDAP_ATTRIBUTE_SUPPORTED_ID = "attributeSupportedId";
    private String attributeSupportedId;
    private static final String XACML_LDAP_SUBSTITUTE_VALUE = "substituteValue";
    private String substituteValue;
    private static final String XACML_LDAP_VALUE_DATA_TYPE = "valueDataType";
    private String valueDataType;
    private Properties env = new Properties();
    private InitialLdapContext ctx = null;

    public void processOptions(List<Option> theoptions) {
        for (Option option : theoptions) {
            this.processPassedOption(option.getName(), (String)option.getContent().iterator().next());
        }
        this.fillInMissingConfigurationWithDefaults();
    }

    public void processPassedOption(String optionTag, String optionValue) {
        String name = optionTag;
        if (name.equals(XACML_LDAP_URL)) {
            this.url = optionValue;
        } else if (name.equals(XACML_LDAP_FACTORY)) {
            this.factory = optionValue;
        } else if (name.equals(XACML_LDAP_USERNAME)) {
            this.username = optionValue;
        } else if (name.equals(XACML_LDAP_PASSWORD)) {
            this.password = optionValue;
        } else if (name.equals(XACML_LDAP_FILTER)) {
            this.filter = optionValue;
        } else if (name.equals(XACML_LDAP_ATTRIBUTE)) {
            this.attribute = optionValue;
        } else if (name.equals(XACML_LDAP_BASEDN)) {
            this.baseDN = optionValue;
        } else if (name.equals(XACML_LDAP_SEARCH_TIMELIMIT)) {
            String timeLimit = optionValue;
            if (timeLimit != null) {
                try {
                    this.searchTimeLimit = Integer.parseInt(timeLimit);
                }
                catch (NumberFormatException e) {
                    log.fine("Failed to parse: " + timeLimit + ", using searchTimeLimit = " + this.searchTimeLimit + ". " + e.getMessage());
                }
            }
        } else if (name.equals(XACML_LDAP_SEARCH_SCOPE)) {
            String scope = optionValue;
            if ("OBJECT_SCOPE".equalsIgnoreCase(scope)) {
                this.searchScope = 0;
            } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
                this.searchScope = 1;
            }
            if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
                this.searchScope = 2;
            }
        } else if (name.equals(XACML_LDAP_SALT)) {
            this.salt = optionValue;
        } else if (name.equals(XACML_LDAP_COUNT)) {
            this.iterationCount = Integer.parseInt(optionValue);
        } else if (name.equals(XACML_LDAP_ATTRIBUTE_SUPPORTED_ID)) {
            this.attributeSupportedId = optionValue;
        } else if (name.equals(XACML_LDAP_SUBSTITUTE_VALUE)) {
            this.substituteValue = optionValue;
        } else if (name.equals(XACML_LDAP_VALUE_DATA_TYPE)) {
            this.valueDataType = optionValue;
        } else if (name.equals("java.naming.factory.initial")) {
            this.factory = optionValue;
        } else if (name.equals("java.naming.provider.url")) {
            this.url = optionValue;
        }
    }

    public void validateConfiguration(TYPE locatorType) {
        if (this.url == null) {
            throw new IllegalArgumentException("Option url cannot be null");
        }
        if (this.filter == null) {
            throw new IllegalArgumentException("Option filter cannot be null");
        }
        if (this.attribute == null) {
            throw new IllegalArgumentException("Option attribute cannot be null");
        }
        if (locatorType == TYPE.ATTRIBUTE) {
            if (this.valueDataType == null) {
                throw new IllegalArgumentException("Option valueDataType cannot be null");
            }
            if (this.attributeSupportedId == null) {
                throw new IllegalArgumentException("Option attributeSupportedId cannot be null");
            }
            if (this.substituteValue == null) {
                throw new IllegalArgumentException("Option substituteValue cannot be null");
            }
        }
    }

    public String getLdapAttribute() {
        return this.attribute;
    }

    public String getDataTypeOfSubstituteValue() {
        return this.valueDataType;
    }

    public String getSubsititeValue() {
        return this.substituteValue;
    }

    public NamingEnumeration<SearchResult> search(Object[] filterArgs) throws NamingException {
        InitialLdapContext ctx = new InitialLdapContext(this.env, null);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(this.searchScope);
        constraints.setTimeLimit(this.searchTimeLimit);
        constraints.setReturningAttributes(new String[]{this.attribute});
        if (filterArgs != null) {
            return ctx.search(this.baseDN, this.filter, filterArgs, constraints);
        }
        return ctx.search(this.baseDN, this.filter, constraints);
    }

    public void constructJNDIContext() throws NamingException {
        if (this.password != null && this.password.startsWith(XACML_LDAP_PASSWORD_PREFIX)) {
            if (this.salt == null || this.salt.equals("") || this.salt.length() != 8) {
                throw new IllegalArgumentException("Option salt is not set correctly");
            }
            if (this.iterationCount == 0) {
                throw new IllegalArgumentException("Option iterationCount must be a positive integer");
            }
            this.password = this.decodePassword(this.password);
        }
        this.env.put("java.naming.factory.initial", this.factory);
        this.env.put("java.naming.provider.url", this.url);
        if (this.username != null) {
            this.env.put("java.naming.security.principal", this.username);
        }
        if (this.password != null) {
            this.env.put("java.naming.security.credentials", this.password);
        }
        this.ctx = new InitialLdapContext(this.env, null);
    }

    public void closeJNDIContext() throws NamingException {
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    private void fillInMissingConfigurationWithDefaults() {
        if (this.factory == null) {
            this.factory = "com.sun.jndi.ldap.LdapCtxFactory";
        }
    }

    private String decodePassword(String encodedPassword) {
        try {
            String password = encodedPassword.substring(XACML_LDAP_PASSWORD_PREFIX.length());
            byte[] salt = this.salt.getBytes();
            char[] p = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
            PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, this.iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(p);
            String cipherAlgorithm = "PBEwithMD5andDES";
            SecretKeyFactory factory = SecretKeyFactory.getInstance(cipherAlgorithm);
            SecretKey cipherKey = factory.generateSecret(keySpec);
            return PBEUtils.decode64((String)password, (String)cipherAlgorithm, (SecretKey)cipherKey, (PBEParameterSpec)cipherSpec);
        }
        catch (Exception e) {
            log.severe("Could not decode masked password. " + e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        POLICY,
        ATTRIBUTE;

    }
}

