/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceDefinition;
import org.jboss.as.messaging.ConnectorServiceParamDefinition;
import org.jboss.as.messaging.DiscoveryGroupDefinition;
import org.jboss.as.messaging.DivertDefinition;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.HTTPAcceptorDefinition;
import org.jboss.as.messaging.HornetQServerResourceDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.PathDefinition;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.TransportParamDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.JMSQueueDefinition;
import org.jboss.as.messaging.jms.JMSTopicDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;

public class MessagingTransformers {
    static void registerTransformers(SubsystemRegistration subsystem) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)subsystem.getSubsystemVersion());
        MessagingTransformers.buildTransformers2_1_0(chainedBuilder.createBuilder(subsystem.getSubsystemVersion(), MessagingExtension.VERSION_2_1_0));
        MessagingTransformers.buildTransformers2_0_0(chainedBuilder.createBuilder(MessagingExtension.VERSION_2_1_0, MessagingExtension.VERSION_2_0_0));
        MessagingTransformers.buildTransformers1_3_0(chainedBuilder.createBuilder(MessagingExtension.VERSION_2_0_0, MessagingExtension.VERSION_1_3_0));
        MessagingTransformers.buildTransformers1_2_1(chainedBuilder.createBuilder(MessagingExtension.VERSION_1_3_0, MessagingExtension.VERSION_1_2_1));
        MessagingTransformers.buildTransformers1_2_0(chainedBuilder.createBuilder(MessagingExtension.VERSION_1_2_1, MessagingExtension.VERSION_1_2_0));
        MessagingTransformers.buildTransformers1_1_0(chainedBuilder.createBuilder(MessagingExtension.VERSION_1_2_0, MessagingExtension.VERSION_1_1_0));
        chainedBuilder.buildAndRegister(subsystem, (ModelVersion[][])new ModelVersion[][]{{MessagingExtension.VERSION_1_1_0, MessagingExtension.VERSION_1_2_0, MessagingExtension.VERSION_1_2_1, MessagingExtension.VERSION_1_3_0, MessagingExtension.VERSION_2_0_0, MessagingExtension.VERSION_2_1_0}});
    }

    private static void buildTransformers2_1_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder hornetqServer = builder.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(hornetqServer, new AttributeDefinition[]{CommonAttributes.OVERRIDE_IN_VM_SECURITY});
        ResourceTransformationDescriptionBuilder addressSetting = hornetqServer.addChildResource(AddressSettingDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(addressSetting, new AttributeDefinition[]{AddressSettingDefinition.MAX_REDELIVERY_DELAY, AddressSettingDefinition.REDELIVERY_MULTIPLIER, AddressSettingDefinition.SLOW_CONSUMER_CHECK_PERIOD, AddressSettingDefinition.SLOW_CONSUMER_POLICY, AddressSettingDefinition.SLOW_CONSUMER_THRESHOLD});
    }

    private static void buildTransformers2_0_0(ResourceTransformationDescriptionBuilder builder) {
    }

    private static void buildTransformers1_3_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder hornetqServer = builder.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        MessagingTransformers.renameAttribute(hornetqServer, (AttributeDefinition)CommonAttributes.STATISTICS_ENABLED, (AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_ENABLED);
        hornetqServer.rejectChildResource(HTTPAcceptorDefinition.PATH);
        hornetqServer.rejectChildResource(PathElement.pathElement((String)"http-connector"));
        ResourceTransformationDescriptionBuilder bridge = hornetqServer.addChildResource(BridgeDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(bridge, new AttributeDefinition[]{BridgeDefinition.RECONNECT_ATTEMPTS_ON_SAME_NODE, BridgeDefinition.INITIAL_CONNECT_ATTEMPTS});
        ResourceTransformationDescriptionBuilder clusterConnection = hornetqServer.addChildResource(ClusterConnectionDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(clusterConnection, new AttributeDefinition[]{ClusterConnectionDefinition.INITIAL_CONNECT_ATTEMPTS});
        ResourceTransformationDescriptionBuilder addressSetting = hornetqServer.addChildResource(AddressSettingDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(addressSetting, new AttributeDefinition[]{AddressSettingDefinition.EXPIRY_DELAY});
    }

    private static void buildTransformers1_2_1(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder hornetqServer = builder.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(hornetqServer, CommonAttributes.MAX_SAVED_REPLICATED_JOURNAL_SIZE);
        ResourceTransformationDescriptionBuilder bridge = hornetqServer.addChildResource(BridgeDefinition.PATH);
        bridge.getAttributeBuilder().setDiscard(new DiscardAttributeChecker(){

            public boolean isDiscardExpressions() {
                return false;
            }

            public boolean isDiscardUndefined() {
                return true;
            }

            public boolean isOperationParameterDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
                return false;
            }

            public boolean isResourceAttributeDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return true;
            }
        }, new AttributeDefinition[]{CommonAttributes.FAILOVER_ON_SERVER_SHUTDOWN});
        ResourceTransformationDescriptionBuilder groupingHandler = hornetqServer.addChildResource(GroupingHandlerDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(groupingHandler, new AttributeDefinition[]{GroupingHandlerDefinition.GROUP_TIMEOUT, GroupingHandlerDefinition.REAPER_PERIOD});
    }

    private static void buildTransformers1_2_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder hornetqServer = builder.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        hornetqServer.getAttributeBuilder().setDiscard(new DiscardAttributeChecker(){

            public boolean isDiscardExpressions() {
                return false;
            }

            public boolean isDiscardUndefined() {
                return true;
            }

            public boolean isOperationParameterDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
                Set clusterConnectionNames = context.readResourceFromRoot(address).getChildrenNames(ClusterConnectionDefinition.PATH.getKey());
                boolean clustered = !clusterConnectionNames.isEmpty();
                boolean wantsClustered = attributeValue.asBoolean(clustered);
                if (clustered && !wantsClustered) {
                    String msg = MessagingLogger.ROOT_LOGGER.canNotChangeClusteredAttribute(address);
                    context.getLogger().logAttributeWarning(address, operation, msg, CommonAttributes.CLUSTERED.getName());
                }
                return true;
            }

            public boolean isResourceAttributeDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return true;
            }
        }, new AttributeDefinition[]{CommonAttributes.CLUSTERED});
    }

    private static void buildTransformers1_1_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder transportParam;
        OperationTransformationOverrideBuilder transportAddOp;
        ResourceTransformationDescriptionBuilder transport;
        builder.rejectChildResource(JMSBridgeDefinition.PATH);
        ResourceTransformationDescriptionBuilder hornetqServer = builder.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        MessagingTransformers.rejectAttributesWithExpression(hornetqServer, HornetQServerResourceDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0);
        MessagingTransformers.rejectDefinedAttribute(hornetqServer, new AttributeDefinition[]{CommonAttributes.BACKUP_GROUP_NAME, CommonAttributes.REPLICATION_CLUSTERNAME, CommonAttributes.REMOTING_INCOMING_INTERCEPTORS, CommonAttributes.REMOTING_OUTGOING_INTERCEPTORS});
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(hornetqServer, new AttributeDefinition[]{CommonAttributes.CHECK_FOR_LIVE_SERVER});
        MessagingTransformers.convertUndefinedAttribute(hornetqServer, new AttributeDefinition[]{CommonAttributes.ID_CACHE_SIZE});
        for (String path : PathDefinition.PATHS.keySet()) {
            ResourceTransformationDescriptionBuilder serverPaths = hornetqServer.addChildResource(PathElement.pathElement((String)"path", (String)path));
            MessagingTransformers.rejectAttributesWithExpression(serverPaths, "path");
        }
        for (String path : new String[]{"in-vm-acceptor", "in-vm-connector"}) {
            transport = hornetqServer.addChildResource(PathElement.pathElement((String)path));
            MessagingTransformers.rejectAttributesWithExpression(transport, new AttributeDefinition[]{InVMTransportDefinition.SERVER_ID});
            transportAddOp = transport.addOperationTransformationOverride("add").inheritResourceAttributeDefinitions();
            MessagingTransformers.rejectAttributesWithExpression(transportAddOp, "param");
            transportParam = transport.addChildResource(TransportParamDefinition.PATH);
            MessagingTransformers.rejectAttributesWithExpression(transportParam, new AttributeDefinition[]{TransportParamDefinition.VALUE});
        }
        for (String path : new String[]{"remote-acceptor", "remote-connector", "acceptor", "connector"}) {
            transport = hornetqServer.addChildResource(PathElement.pathElement((String)path));
            transportAddOp = transport.addOperationTransformationOverride("add").inheritResourceAttributeDefinitions();
            MessagingTransformers.rejectAttributesWithExpression(transportAddOp, "param");
            transportParam = transport.addChildResource(TransportParamDefinition.PATH);
            MessagingTransformers.rejectAttributesWithExpression(transportParam, new AttributeDefinition[]{TransportParamDefinition.VALUE});
        }
        ResourceTransformationDescriptionBuilder broadcastGroup = hornetqServer.addChildResource(BroadcastGroupDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(broadcastGroup, new AttributeDefinition[]{BroadcastGroupDefinition.BROADCAST_PERIOD});
        MessagingTransformers.rejectDefinedAttribute(broadcastGroup, new AttributeDefinition[]{CommonAttributes.JGROUPS_CHANNEL, CommonAttributes.JGROUPS_STACK});
        ResourceTransformationDescriptionBuilder discoveryGroup = hornetqServer.addChildResource(DiscoveryGroupDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(discoveryGroup, new AttributeDefinition[]{DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT, DiscoveryGroupDefinition.REFRESH_TIMEOUT});
        MessagingTransformers.rejectDefinedAttribute(discoveryGroup, new AttributeDefinition[]{CommonAttributes.JGROUPS_CHANNEL, CommonAttributes.JGROUPS_STACK});
        ResourceTransformationDescriptionBuilder divert = hornetqServer.addChildResource(DivertDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(divert, new AttributeDefinition[]{DivertDefinition.ROUTING_NAME, DivertDefinition.ADDRESS, DivertDefinition.FORWARDING_ADDRESS, CommonAttributes.FILTER, DivertDefinition.EXCLUSIVE});
        ResourceTransformationDescriptionBuilder queue = hornetqServer.addChildResource(QueueDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(queue, new AttributeDefinition[]{QueueDefinition.ADDRESS, CommonAttributes.FILTER, CommonAttributes.DURABLE});
        ResourceTransformationDescriptionBuilder bridge = hornetqServer.addChildResource(BridgeDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(bridge, BridgeDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0);
        ResourceTransformationDescriptionBuilder clusterConnection = hornetqServer.addChildResource(ClusterConnectionDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(clusterConnection, ClusterConnectionDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(clusterConnection, new AttributeDefinition[]{CommonAttributes.CALL_FAILOVER_TIMEOUT, ClusterConnectionDefinition.NOTIFICATION_ATTEMPTS, ClusterConnectionDefinition.NOTIFICATION_INTERVAL, ClusterConnectionDefinition.INITIAL_CONNECT_ATTEMPTS});
        ResourceTransformationDescriptionBuilder groupingHandler = hornetqServer.addChildResource(GroupingHandlerDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(groupingHandler, new AttributeDefinition[]{GroupingHandlerDefinition.TYPE, GroupingHandlerDefinition.GROUPING_HANDLER_ADDRESS, GroupingHandlerDefinition.TIMEOUT});
        ResourceTransformationDescriptionBuilder addressSetting = hornetqServer.addChildResource(AddressSettingDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(addressSetting, AddressSettingDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0);
        ResourceTransformationDescriptionBuilder connectorService = hornetqServer.addChildResource(ConnectorServiceDefinition.PATH);
        ResourceTransformationDescriptionBuilder connectorServiceParam = connectorService.addChildResource(ConnectorServiceParamDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(connectorServiceParam, new AttributeDefinition[]{ConnectorServiceParamDefinition.VALUE});
        ResourceTransformationDescriptionBuilder connectionFactory = hornetqServer.addChildResource(ConnectionFactoryDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(connectionFactory, ConnectionFactoryDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(connectionFactory, new AttributeDefinition[]{CommonAttributes.CALL_FAILOVER_TIMEOUT});
        MessagingTransformers.convertUndefinedAttribute(connectionFactory, ConnectionFactoryAttributes.Regular.FACTORY_TYPE);
        ResourceTransformationDescriptionBuilder pooledConnectionFactory = hornetqServer.addChildResource(PooledConnectionFactoryDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(pooledConnectionFactory, PooledConnectionFactoryDefinition.ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0);
        MessagingTransformers.convertUndefinedAttribute(pooledConnectionFactory, ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(pooledConnectionFactory, new AttributeDefinition[]{CommonAttributes.CALL_FAILOVER_TIMEOUT, ConnectionFactoryAttributes.Pooled.INITIAL_CONNECT_ATTEMPTS, ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES, ConnectionFactoryAttributes.Pooled.INITIAL_MESSAGE_PACKET_SIZE, ConnectionFactoryAttributes.Pooled.USE_AUTO_RECOVERY});
        ResourceTransformationDescriptionBuilder jmsQueue = hornetqServer.addChildResource(JMSQueueDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(jmsQueue, new AttributeDefinition[]{CommonAttributes.DESTINATION_ENTRIES, CommonAttributes.SELECTOR, CommonAttributes.DURABLE});
        ResourceTransformationDescriptionBuilder jmsTopic = hornetqServer.addChildResource(JMSTopicDefinition.PATH);
        MessagingTransformers.rejectAttributesWithExpression(jmsTopic, new AttributeDefinition[]{CommonAttributes.DESTINATION_ENTRIES});
    }

    private static void rejectDefinedAttribute(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        for (AttributeDefinition attr : attrs) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{attr})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{attr});
        }
    }

    private static void rejectDefinedAttributeWithDefaultValue(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        for (AttributeDefinition attr : attrs) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{attr.getDefaultValue()}), new AttributeDefinition[]{attr})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{attr});
        }
    }

    private static void rejectAttributesWithExpression(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, attrs);
    }

    private static void rejectAttributesWithExpression(ResourceTransformationDescriptionBuilder builder, String ... attrs) {
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, attrs);
    }

    private static void rejectAttributesWithExpression(OperationTransformationOverrideBuilder operation, String ... attrs) {
        operation.addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, attrs);
    }

    private static void convertUndefinedAttribute(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        for (AttributeDefinition attr : attrs) {
            builder.getAttributeBuilder().setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)attr.getDefaultValue(), (boolean)true), new AttributeDefinition[]{attr});
        }
    }

    private static void discardAttribute(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, attrs);
    }

    private static void renameAttribute(ResourceTransformationDescriptionBuilder builder, AttributeDefinition attribute, AttributeDefinition alias) {
        builder.getAttributeBuilder().addRename(attribute, alias.getName());
    }
}

