/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCreditManager;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientProducerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ConsumerContext;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;

public class DelegatingSession
implements ClientSessionInternal {
    private final ClientSessionInternal session;
    private final Exception creationStack;
    private volatile boolean closed;
    private static Set<DelegatingSession> sessions = new ConcurrentHashSet();
    public static volatile boolean debug;

    public static void dumpSessionCreationStacks() {
        ActiveMQClientLogger.LOGGER.dumpingSessionStacks();
        for (DelegatingSession session : sessions) {
            ActiveMQClientLogger.LOGGER.dumpingSessionStack(session.creationStack);
        }
    }

    public ClientSessionInternal getInternalSession() {
        return this.session;
    }

    protected void finalize() throws Throwable {
        if (!this.closed && !this.session.isClosed()) {
            ActiveMQClientLogger.LOGGER.clientSessionNotClosed(this.creationStack, System.identityHashCode(this));
            this.close();
        }
        super.finalize();
    }

    public DelegatingSession(ClientSessionInternal session) {
        this.session = session;
        this.creationStack = new Exception();
        if (debug) {
            sessions.add(this);
        }
    }

    @Override
    public boolean isClosing() {
        return this.session.isClosing();
    }

    @Override
    public void acknowledge(ClientConsumer consumer, Message message) throws ActiveMQException {
        this.session.acknowledge(consumer, message);
    }

    @Override
    public void individualAcknowledge(ClientConsumer consumer, Message message) throws ActiveMQException {
        this.session.individualAcknowledge(consumer, message);
    }

    @Override
    public void addConsumer(ClientConsumerInternal consumer) {
        this.session.addConsumer(consumer);
    }

    @Override
    public void addFailureListener(SessionFailureListener listener) {
        this.session.addFailureListener(listener);
    }

    @Override
    public void addFailoverListener(FailoverEventListener listener) {
        this.session.addFailoverListener(listener);
    }

    @Override
    public void addProducer(ClientProducerInternal producer) {
        this.session.addProducer(producer);
    }

    @Override
    public ClientSession.AddressQuery addressQuery(SimpleString address) throws ActiveMQException {
        return this.session.addressQuery(address);
    }

    @Override
    public void cleanUp(boolean failingOver) throws ActiveMQException {
        this.session.cleanUp(failingOver);
    }

    @Override
    public void close() throws ActiveMQException {
        this.closed = true;
        if (debug) {
            sessions.remove(this);
        }
        this.session.close();
    }

    @Override
    public void commit() throws ActiveMQException {
        this.session.commit();
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.session.commit(xid, onePhase);
    }

    @Override
    public ClientMessage createMessage(boolean durable) {
        return this.session.createMessage(durable);
    }

    @Override
    public ClientMessage createMessage(byte type, boolean durable, long expiration, long timestamp, byte priority) {
        return this.session.createMessage(type, durable, expiration, timestamp, priority);
    }

    @Override
    public ClientMessage createMessage(byte type, boolean durable) {
        return this.session.createMessage(type, durable);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, boolean browseOnly) throws ActiveMQException {
        return this.session.createConsumer(queueName, filterString, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, int windowSize, int maxRate, boolean browseOnly) throws ActiveMQException {
        return this.session.createConsumer(queueName, filterString, windowSize, maxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString) throws ActiveMQException {
        return this.session.createConsumer(queueName, filterString);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName) throws ActiveMQException {
        return this.session.createConsumer(queueName);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString, boolean browseOnly) throws ActiveMQException {
        return this.session.createConsumer(queueName, filterString, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString, int windowSize, int maxRate, boolean browseOnly) throws ActiveMQException {
        return this.session.createConsumer(queueName, filterString, windowSize, maxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString) throws ActiveMQException {
        return this.session.createConsumer(queueName, filterString);
    }

    @Override
    public ClientConsumer createConsumer(String queueName) throws ActiveMQException {
        return this.session.createConsumer(queueName);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, boolean browseOnly) throws ActiveMQException {
        return this.session.createConsumer(queueName, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, boolean browseOnly) throws ActiveMQException {
        return this.session.createConsumer(queueName, browseOnly);
    }

    @Override
    public ClientProducer createProducer() throws ActiveMQException {
        return this.session.createProducer();
    }

    @Override
    public ClientProducer createProducer(SimpleString address, int rate) throws ActiveMQException {
        return this.session.createProducer(address, rate);
    }

    @Override
    public ClientProducer createProducer(SimpleString address) throws ActiveMQException {
        return this.session.createProducer(address);
    }

    @Override
    public ClientProducer createProducer(String address) throws ActiveMQException {
        return this.session.createProducer(address);
    }

    @Override
    public void createQueue(String address, String queueName) throws ActiveMQException {
        this.session.createQueue(address, queueName);
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName) throws ActiveMQException {
        this.session.createQueue(address, queueName);
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, boolean durable) throws ActiveMQException {
        this.session.createQueue(address, queueName, durable);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, boolean durable) throws ActiveMQException {
        this.session.createSharedQueue(address, queueName, durable);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, SimpleString filter, boolean durable) throws ActiveMQException {
        this.session.createSharedQueue(address, queueName, filter, durable);
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws ActiveMQException {
        this.session.createQueue(address, queueName, filterString, durable);
    }

    @Override
    public void createQueue(String address, String queueName, boolean durable) throws ActiveMQException {
        this.session.createQueue(address, queueName, durable);
    }

    @Override
    public void createQueue(String address, String queueName, String filterString, boolean durable) throws ActiveMQException {
        this.session.createQueue(address, queueName, filterString, durable);
    }

    @Override
    public void createTemporaryQueue(SimpleString address, SimpleString queueName, SimpleString filter) throws ActiveMQException {
        this.session.createTemporaryQueue(address, queueName, filter);
    }

    @Override
    public void createTemporaryQueue(SimpleString address, SimpleString queueName) throws ActiveMQException {
        this.session.createTemporaryQueue(address, queueName);
    }

    @Override
    public void createTemporaryQueue(String address, String queueName, String filter) throws ActiveMQException {
        this.session.createTemporaryQueue(address, queueName, filter);
    }

    @Override
    public void createTemporaryQueue(String address, String queueName) throws ActiveMQException {
        this.session.createTemporaryQueue(address, queueName);
    }

    @Override
    public void deleteQueue(SimpleString queueName) throws ActiveMQException {
        this.session.deleteQueue(queueName);
    }

    @Override
    public void deleteQueue(String queueName) throws ActiveMQException {
        this.session.deleteQueue(queueName);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.session.end(xid, flags);
    }

    @Override
    public void expire(ClientConsumer consumer, Message message) throws ActiveMQException {
        this.session.expire(consumer, message);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.session.forget(xid);
    }

    @Override
    public RemotingConnection getConnection() {
        return this.session.getConnection();
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.session.getMinLargeMessageSize();
    }

    @Override
    public String getName() {
        return this.session.getName();
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.session.getTransactionTimeout();
    }

    @Override
    public int getVersion() {
        return this.session.getVersion();
    }

    @Override
    public XAResource getXAResource() {
        return this.session.getXAResource();
    }

    @Override
    public void preHandleFailover(RemotingConnection connection) {
        this.session.preHandleFailover(connection);
    }

    @Override
    public void handleFailover(RemotingConnection backupConnection, ActiveMQException cause) {
        this.session.handleFailover(backupConnection, cause);
    }

    @Override
    public void handleReceiveMessage(ConsumerContext consumerID, ClientMessageInternal message) throws Exception {
        this.session.handleReceiveMessage(consumerID, message);
    }

    @Override
    public void handleReceiveLargeMessage(ConsumerContext consumerID, ClientLargeMessageInternal clientLargeMessage, long largeMessageSize) throws Exception {
        this.session.handleReceiveLargeMessage(consumerID, clientLargeMessage, largeMessageSize);
    }

    @Override
    public void handleReceiveContinuation(ConsumerContext consumerID, byte[] chunk, int flowControlSize, boolean isContinues) throws Exception {
        this.session.handleReceiveContinuation(consumerID, chunk, flowControlSize, isContinues);
    }

    @Override
    public void handleConsumerDisconnect(ConsumerContext consumerContext) throws ActiveMQException {
        this.session.handleConsumerDisconnect(consumerContext);
    }

    @Override
    public boolean isAutoCommitAcks() {
        return this.session.isAutoCommitAcks();
    }

    @Override
    public boolean isAutoCommitSends() {
        return this.session.isAutoCommitSends();
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.session.isBlockOnAcknowledge();
    }

    @Override
    public boolean isCacheLargeMessageClient() {
        return this.session.isCacheLargeMessageClient();
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return this.session.isSameRM(xares);
    }

    @Override
    public boolean isXA() {
        return this.session.isXA();
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.session.prepare(xid);
    }

    @Override
    public ClientSession.QueueQuery queueQuery(SimpleString queueName) throws ActiveMQException {
        return this.session.queueQuery(queueName);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.session.recover(flag);
    }

    @Override
    public void removeConsumer(ClientConsumerInternal consumer) throws ActiveMQException {
        this.session.removeConsumer(consumer);
    }

    @Override
    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.session.removeFailureListener(listener);
    }

    @Override
    public boolean removeFailoverListener(FailoverEventListener listener) {
        return this.session.removeFailoverListener(listener);
    }

    @Override
    public void removeProducer(ClientProducerInternal producer) {
        this.session.removeProducer(producer);
    }

    @Override
    public void rollback() throws ActiveMQException {
        this.session.rollback();
    }

    @Override
    public boolean isRollbackOnly() {
        return this.session.isRollbackOnly();
    }

    @Override
    public void rollback(boolean considerLastMessageAsDelivered) throws ActiveMQException {
        this.session.rollback(considerLastMessageAsDelivered);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.session.rollback(xid);
    }

    @Override
    public DelegatingSession setSendAcknowledgementHandler(SendAcknowledgementHandler handler) {
        this.session.setSendAcknowledgementHandler(handler);
        return this;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.session.setTransactionTimeout(seconds);
    }

    @Override
    public void resetIfNeeded() throws ActiveMQException {
        this.session.resetIfNeeded();
    }

    @Override
    public DelegatingSession start() throws ActiveMQException {
        this.session.start();
        return this;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.session.start(xid, flags);
    }

    @Override
    public void stop() throws ActiveMQException {
        this.session.stop();
    }

    @Override
    public ClientSessionFactory getSessionFactory() {
        return this.session.getSessionFactory();
    }

    @Override
    public void setForceNotSameRM(boolean force) {
        this.session.setForceNotSameRM(force);
    }

    @Override
    public void workDone() {
        this.session.workDone();
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        this.session.sendProducerCreditsMessage(credits, address);
    }

    @Override
    public ClientProducerCredits getCredits(SimpleString address, boolean anon) {
        return this.session.getCredits(address, anon);
    }

    @Override
    public void returnCredits(SimpleString address) {
        this.session.returnCredits(address);
    }

    @Override
    public void handleReceiveProducerCredits(SimpleString address, int credits) {
        this.session.handleReceiveProducerCredits(address, credits);
    }

    @Override
    public void handleReceiveProducerFailCredits(SimpleString address, int credits) {
        this.session.handleReceiveProducerFailCredits(address, credits);
    }

    @Override
    public ClientProducerCreditManager getProducerCreditManager() {
        return this.session.getProducerCreditManager();
    }

    @Override
    public void setAddress(Message message, SimpleString address) {
        this.session.setAddress(message, address);
    }

    @Override
    public void setPacketSize(int packetSize) {
        this.session.setPacketSize(packetSize);
    }

    @Override
    public void addMetaData(String key, String data) throws ActiveMQException {
        this.session.addMetaData(key, data);
    }

    @Override
    public boolean isCompressLargeMessages() {
        return this.session.isCompressLargeMessages();
    }

    public String toString() {
        return "DelegatingSession [session=" + this.session + "]";
    }

    @Override
    public void addUniqueMetaData(String key, String data) throws ActiveMQException {
        this.session.addUniqueMetaData(key, data);
    }

    @Override
    public void startCall() {
        this.session.startCall();
    }

    @Override
    public void endCall() {
        this.session.endCall();
    }

    @Override
    public void setStopSignal() {
        this.session.setStopSignal();
    }

    @Override
    public boolean isConfirmationWindowEnabled() {
        return this.session.isConfirmationWindowEnabled();
    }

    @Override
    public void scheduleConfirmation(SendAcknowledgementHandler handler, Message msg) {
        this.session.scheduleConfirmation(handler, msg);
    }

    @Override
    public String getNodeId() {
        return this.session.getNodeId();
    }
}

