/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.jboss.logging.Logger;

public class CopyIdentifierComponentSecondPass
implements SecondPass {
    private static final Logger log = Logger.getLogger(CopyIdentifierComponentSecondPass.class);
    private final String referencedEntityName;
    private final Component component;
    private final MetadataBuildingContext buildingContext;
    private final Ejb3JoinColumn[] joinColumns;

    public CopyIdentifierComponentSecondPass(Component comp, String referencedEntityName, Ejb3JoinColumn[] joinColumns, MetadataBuildingContext buildingContext) {
        this.component = comp;
        this.referencedEntityName = referencedEntityName;
        this.buildingContext = buildingContext;
        this.joinColumns = joinColumns;
    }

    @Override
    public void doSecondPass(Map persistentClasses) throws MappingException {
        Ejb3JoinColumn joinColumn;
        String referencedColumnName;
        PersistentClass referencedPersistentClass = (PersistentClass)persistentClasses.get(this.referencedEntityName);
        if (referencedPersistentClass == null) {
            throw new AnnotationException("Unknown entity name: " + this.referencedEntityName);
        }
        if (!(referencedPersistentClass.getIdentifier() instanceof Component)) {
            throw new AssertionFailure("Unexpected identifier type on the referenced entity when mapping a @MapsId: " + this.referencedEntityName);
        }
        Component referencedComponent = (Component)referencedPersistentClass.getIdentifier();
        Iterator properties = referencedComponent.getPropertyIterator();
        boolean isExplicitReference = true;
        HashMap<String, Ejb3JoinColumn> columnByReferencedName = new HashMap<String, Ejb3JoinColumn>(this.joinColumns.length);
        Ejb3JoinColumn[] ejb3JoinColumnArray = this.joinColumns;
        int n = ejb3JoinColumnArray.length;
        for (int i = 0; i < n && (referencedColumnName = (joinColumn = ejb3JoinColumnArray[i]).getReferencedColumn()) != null && !BinderHelper.isEmptyAnnotationValue(referencedColumnName); ++i) {
            columnByReferencedName.put(referencedColumnName.toLowerCase(Locale.ROOT), joinColumn);
        }
        int index = 0;
        if (columnByReferencedName.isEmpty()) {
            isExplicitReference = false;
            for (Ejb3JoinColumn joinColumn2 : this.joinColumns) {
                columnByReferencedName.put("" + index, joinColumn2);
                ++index;
            }
            index = 0;
        }
        while (properties.hasNext()) {
            Property referencedProperty = (Property)properties.next();
            if (referencedProperty.isComposite()) {
                throw new AssertionFailure("Unexpected nested component on the referenced entity when mapping a @MapsId: " + this.referencedEntityName);
            }
            Property property = new Property();
            property.setName(referencedProperty.getName());
            property.setPersistentClass(this.component.getOwner());
            property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
            SimpleValue value = new SimpleValue(this.buildingContext.getMetadataCollector(), this.component.getTable());
            property.setValue(value);
            SimpleValue referencedValue = (SimpleValue)referencedProperty.getValue();
            value.setTypeName(referencedValue.getTypeName());
            value.setTypeParameters(referencedValue.getTypeParameters());
            Iterator<Selectable> columns = referencedValue.getColumnIterator();
            if (this.joinColumns[0].isNameDeferred()) {
                this.joinColumns[0].copyReferencedStructureAndCreateDefaultJoinColumns(referencedPersistentClass, columns, value);
            } else {
                while (columns.hasNext()) {
                    Ejb3JoinColumn joinColumn3;
                    String columnName;
                    Selectable selectable = columns.next();
                    if (!Column.class.isInstance(selectable)) {
                        log.debug((Object)"Encountered formula definition; skipping");
                        continue;
                    }
                    Column column = (Column)selectable;
                    String logicalColumnName = null;
                    if (isExplicitReference) {
                        columnName = column.getName();
                        logicalColumnName = this.buildingContext.getMetadataCollector().getLogicalColumnName(referencedPersistentClass.getTable(), columnName);
                        joinColumn3 = (Ejb3JoinColumn)columnByReferencedName.get(logicalColumnName.toLowerCase(Locale.ROOT));
                    } else {
                        joinColumn3 = (Ejb3JoinColumn)columnByReferencedName.get("" + index);
                        ++index;
                    }
                    if (joinColumn3 == null && !this.joinColumns[0].isNameDeferred()) {
                        throw new AnnotationException(isExplicitReference ? "Unable to find column reference in the @MapsId mapping: " + logicalColumnName : "Implicit column reference in the @MapsId mapping fails, try to use explicit referenceColumnNames: " + this.referencedEntityName);
                    }
                    columnName = joinColumn3 == null || joinColumn3.isNameDeferred() ? "tata_" + column.getName() : joinColumn3.getName();
                    value.addColumn(new Column(columnName));
                    column.setValue(value);
                }
            }
            this.component.addProperty(property);
        }
    }
}

