/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.io.FileWriter;
import java.io.IOException;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.Target;

public class TargetFileImpl
implements Target {
    private FileWriter fileWriter;

    public TargetFileImpl(String outputFile) {
        try {
            this.fileWriter = new FileWriter(outputFile);
        }
        catch (IOException e) {
            throw new SchemaManagementException("Unable to open FileWriter [" + outputFile + "]", e);
        }
    }

    @Override
    public boolean acceptsImportScriptActions() {
        return true;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void accept(String action) {
        try {
            this.fileWriter.write(action);
            this.fileWriter.write("\n");
        }
        catch (IOException e) {
            throw new SchemaManagementException("Unable to write to FileWriter", e);
        }
    }

    @Override
    public void release() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

