/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.capability.Capability;

public abstract class AbstractCapability
implements Capability {
    private final String name;
    private final boolean dynamic;
    private final Set<String> requirements;
    private final Set<String> optionalRequirements;
    private final Set<String> runtimeOnlyRequirements;
    private final Set<String> dynamicRequirements;
    private final Set<String> dynamicOptionalRequirements;

    protected AbstractCapability(String name, boolean dynamic, Set<String> requirements, Set<String> optionalRequirements, Set<String> runtimeOnlyRequirements, Set<String> dynamicRequirements, Set<String> dynamicOptionalRequirements) {
        assert (name != null);
        this.name = name;
        this.dynamic = dynamic;
        this.requirements = AbstractCapability.establishRequirements(requirements);
        this.optionalRequirements = AbstractCapability.establishRequirements(optionalRequirements);
        this.runtimeOnlyRequirements = AbstractCapability.establishRequirements(runtimeOnlyRequirements);
        this.dynamicRequirements = AbstractCapability.establishRequirements(dynamicRequirements);
        this.dynamicOptionalRequirements = AbstractCapability.establishRequirements(dynamicOptionalRequirements);
    }

    private static Set<String> establishRequirements(Set<String> input) {
        if (input != null && !input.isEmpty()) {
            return Collections.unmodifiableSet(new HashSet<String>(input));
        }
        return Collections.emptySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getRequirements() {
        return this.requirements;
    }

    @Override
    public Set<String> getOptionalRequirements() {
        return this.optionalRequirements;
    }

    @Override
    public Set<String> getRuntimeOnlyRequirements() {
        return this.runtimeOnlyRequirements;
    }

    @Override
    public Set<String> getDynamicRequirements() {
        return this.dynamicRequirements;
    }

    @Override
    public Set<String> getDynamicOptionalRequirements() {
        return this.dynamicOptionalRequirements;
    }

    @Override
    public boolean isDynamicallyNamed() {
        return this.dynamic;
    }

    @Override
    public String getDynamicName(String dynamicNameElement) {
        if (!this.dynamic) {
            throw new IllegalStateException();
        }
        return this.name + "." + dynamicNameElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCapability that = (AbstractCapability)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

