/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.notification.NotificationFilter;
import org.jboss.as.controller.notification.NotificationHandler;
import org.jboss.as.controller.registry.NotificationHandlerNodeRegistry;
import org.jboss.as.controller.registry.NotificationHandlerRegistration;

class ConcreteNotificationHandlerRegistration
implements NotificationHandlerRegistration {
    NotificationHandlerNodeRegistry rootRegistry = new NotificationHandlerNodeRegistry(null, null);
    Set<NotificationHandlerEntry> anyAddressEntries = new CopyOnWriteArraySet<NotificationHandlerEntry>();

    ConcreteNotificationHandlerRegistration() {
    }

    @Override
    public void registerNotificationHandler(PathAddress source, NotificationHandler handler, NotificationFilter filter) {
        NotificationHandlerEntry entry = new NotificationHandlerEntry(handler, filter);
        if (source == ANY_ADDRESS) {
            this.anyAddressEntries.add(entry);
            return;
        }
        Iterator iterator = source.iterator();
        this.rootRegistry.registerEntry((ListIterator<PathElement>)iterator, entry);
    }

    @Override
    public void unregisterNotificationHandler(PathAddress source, NotificationHandler handler, NotificationFilter filter) {
        NotificationHandlerEntry entry = new NotificationHandlerEntry(handler, filter);
        if (source == ANY_ADDRESS) {
            this.anyAddressEntries.remove(entry);
            return;
        }
        Iterator iterator = source.iterator();
        this.rootRegistry.unregisterEntry((ListIterator<PathElement>)iterator, entry);
    }

    @Override
    public Collection<NotificationHandler> findMatchingNotificationHandlers(Notification notification) {
        HashSet<NotificationHandler> handlers = new HashSet<NotificationHandler>();
        Iterator iterator = notification.getSource().iterator();
        this.rootRegistry.findEntries((ListIterator<PathElement>)iterator, handlers, notification);
        for (NotificationHandlerEntry anyAddressEntry : this.anyAddressEntries) {
            if (!anyAddressEntry.getFilter().isNotificationEnabled(notification)) continue;
            handlers.add(anyAddressEntry.getHandler());
        }
        return handlers;
    }

    static class NotificationHandlerEntry {
        private final NotificationHandler handler;
        private final NotificationFilter filter;

        NotificationHandlerEntry(NotificationHandler handler, NotificationFilter filter) {
            this.handler = handler;
            this.filter = filter;
        }

        NotificationHandler getHandler() {
            return this.handler;
        }

        NotificationFilter getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotificationHandlerEntry that = (NotificationHandlerEntry)o;
            if (!this.filter.equals(that.filter)) {
                return false;
            }
            return this.handler.equals(that.handler);
        }

        public int hashCode() {
            int result = this.handler.hashCode();
            result = 31 * result + this.filter.hashCode();
            return result;
        }
    }
}

