/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.util.impl;

import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.hcore.impl.SearchFactoryReference;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ContextHelper {
    private ContextHelper() {
    }

    public static ExtendedSearchIntegrator getSearchintegrator(Session session) {
        return ContextHelper.getSearchintegratorBySessionImplementor((SessionImplementor)session);
    }

    public static ExtendedSearchIntegrator getSearchintegratorBySessionImplementor(SessionImplementor session) {
        return ContextHelper.getSearchintegratorBySFI(session.getFactory());
    }

    public static ExtendedSearchIntegrator getSearchintegratorBySFI(SessionFactoryImplementor sfi) {
        SearchFactoryReference factoryReference = (SearchFactoryReference)sfi.getServiceRegistry().getService(SearchFactoryReference.class);
        if (factoryReference != null) {
            return factoryReference.getSearchIntegrator();
        }
        throw LoggerFactory.make().searchFactoryReferenceServiceNotFound();
    }
}

