/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.wildfly.clustering.marshalling.jboss.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.jboss.Marshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineImmutableSessionAttributes<V>
implements ImmutableSessionAttributes {
    private final String id;
    private final Cache<SessionAttributeKey, V> cache;
    private final Marshaller<Object, V, MarshallingContext> marshaller;

    public FineImmutableSessionAttributes(String id, Cache<SessionAttributeKey, V> attributeCache, Marshaller<Object, V, MarshallingContext> marshaller) {
        this.id = id;
        this.cache = attributeCache;
        this.marshaller = marshaller;
    }

    public Set<String> getAttributeNames() {
        return this.cache.getAdvancedCache().getGroup(this.id).keySet().stream().filter(object -> object instanceof SessionAttributeKey).map(key -> key.getAttribute()).collect(Collectors.toSet());
    }

    public Object getAttribute(String name) {
        SessionAttributeKey key = this.createKey(name);
        return this.read(name, this.cache.get((Object)key));
    }

    protected SessionAttributeKey createKey(String attribute) {
        return new SessionAttributeKey(this.id, attribute);
    }

    protected Object read(String name, V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw InfinispanWebLogger.ROOT_LOGGER.failedToReadSessionAttribute(e, this.id, name);
        }
    }
}

