/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.annotations.impl.DocumentationExtractor;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;

class ProtoTypeMetadata {
    protected final String name;
    protected final Class<?> javaClass;
    protected final String documentation;
    protected BaseMarshaller marshaller;
    protected ProtoMessageTypeMetadata outerType;

    public ProtoTypeMetadata(BaseMarshaller marshaller) {
        this.marshaller = marshaller;
        this.name = marshaller.getTypeName();
        this.javaClass = marshaller.getJavaClass();
        this.documentation = null;
    }

    protected ProtoTypeMetadata(String name, Class<?> javaClass) {
        this.name = name;
        this.javaClass = javaClass;
        this.documentation = DocumentationExtractor.getDocumentation(javaClass);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        for (ProtoMessageTypeMetadata t = this.outerType; t != null; t = t.getOuterType()) {
            sb.append(t.getName()).append('.');
        }
        sb.append(this.name);
        return sb.toString();
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public BaseMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(BaseMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public boolean isEnum() {
        return this.marshaller instanceof EnumMarshaller;
    }

    public ProtoMessageTypeMetadata getOuterType() {
        return this.outerType;
    }

    protected void setOuterType(ProtoMessageTypeMetadata outerType) {
        this.outerType = outerType;
    }

    public boolean isTopLevel() {
        return this.outerType == null;
    }

    public void generateProto(IndentWriter iw) {
    }

    public void scanMemberAnnotations() {
    }
}

