/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.aio;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.core.io.AbstractSequentialFileFactory;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFile;
import org.apache.activemq.artemis.jlibaio.LibaioContext;
import org.apache.activemq.artemis.jlibaio.LibaioFile;
import org.apache.activemq.artemis.jlibaio.SubmitInfo;
import org.apache.activemq.artemis.jlibaio.util.CallbackCache;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;

public final class AIOSequentialFileFactory
extends AbstractSequentialFileFactory {
    private static final boolean trace = ActiveMQJournalLogger.LOGGER.isTraceEnabled();
    private final ReuseBuffersController buffersControl = new ReuseBuffersController();
    private volatile boolean reuseBuffers = true;
    private ExecutorService pollerExecutor;
    volatile LibaioContext<AIOSequentialCallback> libaioContext;
    private final CallbackCache<AIOSequentialCallback> callbackPool;
    private final AtomicBoolean running = new AtomicBoolean(false);

    private static void trace(String message) {
        ActiveMQJournalLogger.LOGGER.trace(message);
    }

    public AIOSequentialFileFactory(File journalDir, int maxIO) {
        this(journalDir, 501760, 500000, maxIO, false, null);
    }

    public AIOSequentialFileFactory(File journalDir, IOCriticalErrorListener listener, int maxIO) {
        this(journalDir, 501760, 500000, maxIO, false, listener);
    }

    public AIOSequentialFileFactory(File journalDir, int bufferSize, int bufferTimeout, int maxIO, boolean logRates) {
        this(journalDir, bufferSize, bufferTimeout, maxIO, logRates, null);
    }

    public AIOSequentialFileFactory(File journalDir, int bufferSize, int bufferTimeout, int maxIO, boolean logRates, IOCriticalErrorListener listener) {
        super(journalDir, true, bufferSize, bufferTimeout, maxIO, logRates, listener);
        this.callbackPool = new CallbackCache(maxIO);
    }

    public AIOSequentialCallback getCallback() {
        AIOSequentialCallback callback = this.callbackPool.get();
        if (callback == null) {
            callback = new AIOSequentialCallback();
        }
        return callback;
    }

    public void enableBufferReuse() {
        this.reuseBuffers = true;
    }

    public void disableBufferReuse() {
        this.reuseBuffers = false;
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        return new AIOSequentialFile(this, this.bufferSize, this.bufferTimeout, this.journalDir, fileName, this.writeExecutor);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return true;
    }

    public static boolean isSupported() {
        return LibaioContext.isLoaded();
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        int blocks = size / 512;
        if (size % 512 != 0) {
            ++blocks;
        }
        ByteBuffer buffer = LibaioContext.newAlignedBuffer(blocks * 512, 512);
        buffer.limit(size);
        return buffer;
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        LibaioContext.freeBuffer(buffer);
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        if (size % 512 != 0) {
            size = (size / 512 + 1) * 512;
        }
        return this.buffersControl.newBuffer(size);
    }

    @Override
    public void clearBuffer(ByteBuffer directByteBuffer) {
        directByteBuffer.position(0);
        this.libaioContext.memsetBuffer(directByteBuffer);
    }

    @Override
    public int getAlignment() {
        return 512;
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        ByteBuffer newbuffer = this.newBuffer(bytes.length);
        newbuffer.put(bytes);
        return newbuffer;
    }

    @Override
    public int calculateBlockSize(int position) {
        int alignment = this.getAlignment();
        int pos = (position / alignment + (position % alignment != 0 ? 1 : 0)) * alignment;
        return pos;
    }

    @Override
    public synchronized void releaseBuffer(ByteBuffer buffer) {
        LibaioContext.freeBuffer(buffer);
    }

    @Override
    public void start() {
        if (this.running.compareAndSet(false, true)) {
            super.start();
            this.libaioContext = new LibaioContext(this.maxIO, true);
            this.running.set(true);
            this.pollerExecutor = Executors.newCachedThreadPool(new ActiveMQThreadFactory("ActiveMQ-AIO-poller-pool" + System.identityHashCode(this), true, AIOSequentialFileFactory.getThisClassLoader()));
            this.pollerExecutor.execute(new PollerRunnable());
        }
    }

    @Override
    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.buffersControl.stop();
            this.libaioContext.close();
            this.libaioContext = null;
            if (this.pollerExecutor != null) {
                this.pollerExecutor.shutdown();
                try {
                    if (!this.pollerExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                        ActiveMQJournalLogger.LOGGER.timeoutOnPollerShutdown(new Exception("trace"));
                    }
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException(e);
                }
            }
            super.stop();
        }
    }

    protected void finalize() {
        this.stop();
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return AIOSequentialFileFactory.class.getClassLoader();
            }
        });
    }

    public String toString() {
        return AIOSequentialFileFactory.class.getSimpleName() + "(buffersControl.stopped=" + this.buffersControl.stopped + "):" + super.toString();
    }

    private class ReuseBuffersController {
        private volatile long bufferReuseLastTime = System.currentTimeMillis();
        private final ConcurrentLinkedQueue<ByteBuffer> reuseBuffersQueue = new ConcurrentLinkedQueue();
        private boolean stopped = false;

        private ReuseBuffersController() {
        }

        public ByteBuffer newBuffer(int size) {
            if (AIOSequentialFileFactory.this.bufferSize > 0 && System.currentTimeMillis() - this.bufferReuseLastTime > 10000L) {
                if (trace) {
                    AIOSequentialFileFactory.trace("Clearing reuse buffers queue with " + this.reuseBuffersQueue.size() + " elements");
                }
                this.bufferReuseLastTime = System.currentTimeMillis();
                this.clearPoll();
            }
            if (size > AIOSequentialFileFactory.this.bufferSize) {
                return LibaioContext.newAlignedBuffer(size, 512);
            }
            int alignedSize = AIOSequentialFileFactory.this.calculateBlockSize(size);
            ByteBuffer buffer = this.reuseBuffersQueue.poll();
            if (buffer == null) {
                buffer = LibaioContext.newAlignedBuffer(size, 512);
                buffer.limit(alignedSize);
            } else {
                AIOSequentialFileFactory.this.clearBuffer(buffer);
                buffer.limit(alignedSize);
            }
            buffer.rewind();
            return buffer;
        }

        public synchronized void stop() {
            this.stopped = true;
            this.clearPoll();
        }

        public synchronized void clearPoll() {
            ByteBuffer reusedBuffer;
            while ((reusedBuffer = this.reuseBuffersQueue.poll()) != null) {
                AIOSequentialFileFactory.this.releaseBuffer(reusedBuffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bufferDone(ByteBuffer buffer) {
            ReuseBuffersController reuseBuffersController = this;
            synchronized (reuseBuffersController) {
                if (this.stopped) {
                    AIOSequentialFileFactory.this.releaseBuffer(buffer);
                } else {
                    this.bufferReuseLastTime = System.currentTimeMillis();
                    if (buffer.capacity() == AIOSequentialFileFactory.this.bufferSize) {
                        this.reuseBuffersQueue.offer(buffer);
                    } else {
                        AIOSequentialFileFactory.this.releaseBuffer(buffer);
                    }
                }
            }
        }
    }

    private class PollerRunnable
    implements Runnable {
        private PollerRunnable() {
        }

        @Override
        public void run() {
            AIOSequentialFileFactory.this.libaioContext.poll();
        }
    }

    public class AIOSequentialCallback
    implements SubmitInfo,
    Runnable,
    Comparable<AIOSequentialCallback> {
        IOCallback callback;
        boolean error = false;
        AIOSequentialFile sequentialFile;
        ByteBuffer buffer;
        LibaioFile libaioFile;
        String errorMessage;
        int errorCode = -1;
        long writeSequence;
        long position;
        int bytes;

        public String toString() {
            return "AIOSequentialCallback{error=" + this.error + ", errorMessage='" + this.errorMessage + '\'' + ", errorCode=" + this.errorCode + ", writeSequence=" + this.writeSequence + ", position=" + this.position + '}';
        }

        public AIOSequentialCallback initWrite(long positionToWrite, int bytesToWrite) {
            this.position = positionToWrite;
            this.bytes = bytesToWrite;
            return this;
        }

        @Override
        public void run() {
            try {
                this.libaioFile.write(this.position, this.bytes, this.buffer, this);
            }
            catch (IOException e) {
                this.callback.onError(-1, e.getMessage());
            }
        }

        @Override
        public int compareTo(AIOSequentialCallback other) {
            if (this == other || this.writeSequence == other.writeSequence) {
                return 0;
            }
            if (other.writeSequence < this.writeSequence) {
                return 1;
            }
            return -1;
        }

        public AIOSequentialCallback init(long writeSequence, IOCallback IOCallback2, LibaioFile libaioFile, AIOSequentialFile sequentialFile, ByteBuffer usedBuffer) {
            this.callback = IOCallback2;
            this.sequentialFile = sequentialFile;
            this.error = false;
            this.buffer = usedBuffer;
            this.libaioFile = libaioFile;
            this.writeSequence = writeSequence;
            this.errorMessage = null;
            return this;
        }

        @Override
        public void onError(int errno, String message) {
            this.error = true;
            this.errorCode = errno;
            this.errorMessage = message;
        }

        @Override
        public void done() {
            this.sequentialFile.done(this);
        }

        public void sequentialDone() {
            if (this.error) {
                this.callback.onError(this.errorCode, this.errorMessage);
                this.errorMessage = null;
            } else {
                if (this.callback != null) {
                    this.callback.done();
                }
                if (this.buffer != null && AIOSequentialFileFactory.this.reuseBuffers) {
                    AIOSequentialFileFactory.this.buffersControl.bufferDone(this.buffer);
                }
                AIOSequentialFileFactory.this.callbackPool.put(this);
            }
        }
    }
}

