/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4;

import org.hibernate.jpa.boot.archive.spi.ArchiveContext;
import org.hibernate.jpa.boot.archive.spi.ArchiveDescriptor;
import org.hibernate.jpa.boot.archive.spi.ArchiveEntry;
import org.hibernate.jpa.boot.spi.InputStreamAccess;
import org.jboss.as.jpa.hibernate4.VirtualFileInputStreamAccess;
import org.jboss.vfs.VirtualFile;

public class VirtualFileSystemArchiveDescriptor
implements ArchiveDescriptor {
    private final VirtualFile root;

    public VirtualFileSystemArchiveDescriptor(VirtualFile archiveRoot, String entryBase) {
        this.root = entryBase != null && entryBase.length() > 0 && !"/".equals(entryBase) ? archiveRoot.getChild(entryBase) : archiveRoot;
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public void visitArchive(ArchiveContext archiveContext) {
        this.processVirtualFile(this.root, null, archiveContext);
    }

    private void processVirtualFile(VirtualFile virtualFile, String path, ArchiveContext archiveContext) {
        if (path == null) {
            path = "";
        } else if (!path.endsWith("/'")) {
            path = path + "/";
        }
        for (VirtualFile child : virtualFile.getChildren()) {
            if (!child.exists()) continue;
            if (child.isDirectory()) {
                this.processVirtualFile(child, path + child.getName(), archiveContext);
                continue;
            }
            final String name = child.getPathName();
            final String relativeName = path + child.getName();
            final VirtualFileInputStreamAccess inputStreamAccess = new VirtualFileInputStreamAccess(name, child);
            ArchiveEntry entry = new ArchiveEntry(){

                public String getName() {
                    return name;
                }

                public String getNameWithinArchive() {
                    return relativeName;
                }

                public InputStreamAccess getStreamAccess() {
                    return inputStreamAccess;
                }
            };
            archiveContext.obtainArchiveEntryHandler(entry).handleEntry(entry, archiveContext);
        }
    }
}

