/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.mux;

import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RspCollector;
import org.jgroups.blocks.mux.MuxHeader;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.Protocol;

public class MuxRequestCorrelator
extends RequestCorrelator {
    protected static final short MUX_ID = ClassConfigurator.getProtocolId(MuxRequestCorrelator.class);
    private final Header header;

    public MuxRequestCorrelator(short id, Protocol transport, RequestHandler handler, Address localAddr) {
        super(ClassConfigurator.getProtocolId(RequestCorrelator.class), transport, handler, localAddr);
        this.header = new MuxHeader(id);
    }

    @Override
    public void sendRequest(long requestId, Collection<Address> dest_mbrs, Message msg, RspCollector coll, RequestOptions options) throws Exception {
        msg.putHeader(MUX_ID, this.header);
        super.sendRequest(requestId, dest_mbrs, msg, coll, options);
    }

    @Override
    public void sendUnicastRequest(long id, Address target, Message msg, RspCollector coll) throws Exception {
        msg.putHeader(MUX_ID, this.header);
        super.sendUnicastRequest(id, target, msg, coll);
    }

    @Override
    protected void prepareResponse(Message rsp) {
        rsp.putHeader(MUX_ID, this.header);
        super.prepareResponse(rsp);
    }
}

