/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.interceptors.BatchingInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.impl.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.RemoteQueryEngine;
import org.infinispan.query.remote.impl.filter.JPABinaryProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.filter.JPAContinuousQueryProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.JPAProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.JPAProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.RemoteValueWrapperInterceptor;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.util.logging.LogFactory;

public final class LifecycleManager
extends AbstractModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.PROTOBUF_VALUE_WRAPPER, new ProtobufValueWrapper.Externalizer());
        externalizerMap.put(ExternalizerIds.JPA_PROTOBUF_CACHE_EVENT_FILTER_CONVERTER, new JPAProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.JPA_PROTOBUF_FILTER_AND_CONVERTER, new JPAProtobufFilterAndConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.JPA_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER, new JPAContinuousQueryProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.JPA_BINARY_PROTOBUF_FILTER_AND_CONVERTER, new JPABinaryProtobufFilterAndConverter.Externalizer());
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        this.initProtobufMetadataManager((DefaultCacheManager)cacheManager, gcr);
    }

    private void initProtobufMetadataManager(DefaultCacheManager cacheManager, GlobalComponentRegistry gcr) {
        ProtobufMetadataManagerImpl protobufMetadataManager = new ProtobufMetadataManagerImpl();
        gcr.registerComponent((Object)protobufMetadataManager, ProtobufMetadataManager.class);
        this.registerProtobufMetadataManagerMBean(protobufMetadataManager, gcr, cacheManager.getName());
    }

    private void registerProtobufMetadataManagerMBean(ProtobufMetadataManager protobufMetadataManager, GlobalComponentRegistry gcr, String cacheManagerName) {
        GlobalConfiguration globalCfg = gcr.getGlobalConfiguration();
        MBeanServer mBeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
        String groupName = "type=RemoteQuery,name=" + ObjectName.quote(cacheManagerName);
        String jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)mBeanServer, (String)groupName);
        ComponentMetadataRepo metadataRepo = gcr.getComponentMetadataRepo();
        ManageableComponentMetadata metadata = metadataRepo.findComponentMetadata(ProtobufMetadataManagerImpl.class).toManageableComponentMetadata();
        try {
            ResourceDMBean mBean = new ResourceDMBean((Object)protobufMetadataManager, metadata);
            ObjectName objName = new ObjectName(jmxDomain + ":" + groupName + ",component=" + metadata.getJmxObjectName());
            protobufMetadataManager.setObjectName(objName);
            JmxUtil.registerMBean((Object)mBean, (ObjectName)objName, (MBeanServer)mBeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to register ProtobufMetadataManager MBean", (Throwable)e);
        }
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        this.unregisterProtobufMetadataManagerMBean(gcr);
    }

    private void unregisterProtobufMetadataManagerMBean(GlobalComponentRegistry gcr) {
        try {
            ObjectName objName = ((ProtobufMetadataManager)gcr.getComponent(ProtobufMetadataManager.class)).getObjectName();
            MBeanServer mBeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)gcr.getGlobalConfiguration());
            JmxUtil.unregisterMBean((ObjectName)objName, (MBeanServer)mBeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to unregister ProtobufMetadataManager MBean", (Throwable)e);
        }
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName)) {
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)cr.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
            cr.registerComponent((Object)new ProtobufMatcher(protobufMetadataManager.getSerializationContext()), ProtobufMatcher.class);
            if (cfg.compatibility().enabled()) {
                cr.registerComponent((Object)new CompatibilityReflectionMatcher(protobufMetadataManager.getSerializationContext()), CompatibilityReflectionMatcher.class);
            }
            if (cfg.indexing().index().isEnabled() && !cfg.compatibility().enabled()) {
                log.infof("Registering RemoteValueWrapperInterceptor for cache %s", cacheName);
                this.createRemoteValueWrapperInterceptor(cr, cfg);
            }
        }
    }

    private void createRemoteValueWrapperInterceptor(ComponentRegistry cr, Configuration cfg) {
        RemoteValueWrapperInterceptor wrapperInterceptor = (RemoteValueWrapperInterceptor)((Object)cr.getComponent(RemoteValueWrapperInterceptor.class));
        if (wrapperInterceptor == null) {
            wrapperInterceptor = new RemoteValueWrapperInterceptor();
            InterceptorChain ic = (InterceptorChain)cr.getComponent(InterceptorChain.class);
            ConfigurationBuilder builder = new ConfigurationBuilder().read(cfg);
            InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
            interceptorBuilder.interceptor(wrapperInterceptor);
            if (cfg.invocationBatching().enabled()) {
                if (ic != null) {
                    ic.addInterceptorAfter(wrapperInterceptor, BatchingInterceptor.class);
                }
                interceptorBuilder.after(BatchingInterceptor.class);
            } else {
                if (ic != null) {
                    ic.addInterceptorAfter(wrapperInterceptor, InvocationContextInterceptor.class);
                }
                interceptorBuilder.after(InvocationContextInterceptor.class);
            }
            if (ic != null) {
                cr.registerComponent(wrapperInterceptor, RemoteValueWrapperInterceptor.class);
            }
            cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
        }
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        InternalCacheRegistry icr;
        boolean remoteValueWrappingEnabled;
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        boolean isIndexed = configuration.indexing().index().isEnabled();
        boolean isCompatMode = configuration.compatibility().enabled();
        boolean bl = remoteValueWrappingEnabled = isIndexed && !isCompatMode;
        if (remoteValueWrappingEnabled) {
            if (!this.verifyChainContainsRemoteValueWrapperInterceptor(cr)) {
                throw new IllegalStateException("It was expected to find the RemoteValueWrapperInterceptor registered in the InterceptorChain but it wasn't found");
            }
        } else if (this.verifyChainContainsRemoteValueWrapperInterceptor(cr)) {
            throw new IllegalStateException("It was NOT expected to find the RemoteValueWrapperInterceptor registered in the InterceptorChain as indexing was disabled, but it was found");
        }
        if (!(icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class)).isInternalCache(cacheName)) {
            AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache().withFlags(new Flag[]{Flag.OPERATION_HOTROD});
            SerializationContext serCtx = ProtobufMetadataManagerImpl.getSerializationContextInternal(cache.getCacheManager());
            SearchManager searchManager = isIndexed ? Search.getSearchManager((Cache)cache) : null;
            RemoteQueryEngine remoteQueryEngine = new RemoteQueryEngine(cache, searchManager, isCompatMode, serCtx);
            cr.registerComponent((Object)remoteQueryEngine, RemoteQueryEngine.class);
        }
    }

    private boolean verifyChainContainsRemoteValueWrapperInterceptor(ComponentRegistry cr) {
        InterceptorChain interceptorChain = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        return interceptorChain != null && interceptorChain.containsInterceptorType(RemoteValueWrapperInterceptor.class, true);
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        this.removeRemoteIndexingInterceptorFromConfig(cfg);
    }

    private void removeRemoteIndexingInterceptorFromConfig(Configuration cfg) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        CustomInterceptorsConfigurationBuilder customInterceptorsBuilder = builder.customInterceptors();
        for (InterceptorConfiguration interceptorConfig : cfg.customInterceptors().interceptors()) {
            if (interceptorConfig.interceptor() instanceof RemoteValueWrapperInterceptor) continue;
            customInterceptorsBuilder.addInterceptor().read(interceptorConfig);
        }
        cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
    }
}

