/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.DeprecatedAttributeWriteHandler;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;

public class HornetQServerResourceDefinition
extends ModelOnlyResourceDefinition {
    public static final PathElement HORNETQ_SERVER_PATH = PathElement.pathElement((String)"hornetq-server");
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{CommonAttributes.ASYNC_CONNECTION_EXECUTION_ENABLED, CommonAttributes.PERSISTENCE_ENABLED, CommonAttributes.SECURITY_ENABLED, CommonAttributes.SECURITY_INVALIDATION_INTERVAL, CommonAttributes.WILD_CARD_ROUTING_ENABLED, CommonAttributes.MANAGEMENT_ADDRESS, CommonAttributes.MANAGEMENT_NOTIFICATION_ADDRESS, CommonAttributes.JMX_MANAGEMENT_ENABLED, CommonAttributes.JMX_DOMAIN, CommonAttributes.STATISTICS_ENABLED, CommonAttributes.MESSAGE_COUNTER_ENABLED, CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD, CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY, CommonAttributes.CONNECTION_TTL_OVERRIDE, CommonAttributes.TRANSACTION_TIMEOUT, CommonAttributes.TRANSACTION_TIMEOUT_SCAN_PERIOD, CommonAttributes.MESSAGE_EXPIRY_SCAN_PERIOD, CommonAttributes.MESSAGE_EXPIRY_THREAD_PRIORITY, CommonAttributes.ID_CACHE_SIZE, CommonAttributes.PERSIST_ID_CACHE, CommonAttributes.BACKUP, CommonAttributes.ALLOW_FAILBACK, CommonAttributes.FAILBACK_DELAY, CommonAttributes.FAILOVER_ON_SHUTDOWN, CommonAttributes.SHARED_STORE, CommonAttributes.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY, CommonAttributes.PAGE_MAX_CONCURRENT_IO, CommonAttributes.CREATE_BINDINGS_DIR, CommonAttributes.CREATE_JOURNAL_DIR, CommonAttributes.JOURNAL_TYPE, CommonAttributes.JOURNAL_BUFFER_TIMEOUT, CommonAttributes.JOURNAL_BUFFER_SIZE, CommonAttributes.JOURNAL_SYNC_TRANSACTIONAL, CommonAttributes.JOURNAL_SYNC_NON_TRANSACTIONAL, CommonAttributes.LOG_JOURNAL_WRITE_RATE, CommonAttributes.JOURNAL_FILE_SIZE, CommonAttributes.JOURNAL_MIN_FILES, CommonAttributes.JOURNAL_COMPACT_PERCENTAGE, CommonAttributes.JOURNAL_COMPACT_MIN_FILES, CommonAttributes.JOURNAL_MAX_IO, CommonAttributes.PERF_BLAST_PAGES, CommonAttributes.RUN_SYNC_SPEED_TEST, CommonAttributes.SERVER_DUMP_INTERVAL};
    static final HornetQServerResourceDefinition INSTANCE = new HornetQServerResourceDefinition();

    private HornetQServerResourceDefinition() {
        super(HORNETQ_SERVER_PATH, MessagingExtension.getResourceDescriptionResolver("hornetq-server"), new ModelOnlyAddStepHandler(CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES){

            protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
                super.populateModel(operation, model);
                if (model.hasDefined(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName())) {
                    ModelNode mceVal = model.get(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName());
                    ModelNode seVal = model.get(CommonAttributes.STATISTICS_ENABLED.getName());
                    if (seVal.isDefined() && !seVal.equals(mceVal)) {
                        throw MessagingLogger.ROOT_LOGGER.inconsistentStatisticsSettings(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName(), CommonAttributes.STATISTICS_ENABLED.getName());
                    }
                    seVal.set(mceVal);
                    model.remove(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName());
                }
            }
        }, CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES);
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ModelOnlyWriteAttributeHandler writeHandler = new ModelOnlyWriteAttributeHandler(CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES);
        for (AttributeDefinition ad : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            if (ad.getName().equals(CommonAttributes.CLUSTERED.getName())) {
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CommonAttributes.CLUSTERED, ClusteredAttributeHandlers.READ_HANDLER, ClusteredAttributeHandlers.WRITE_HANDLER);
                continue;
            }
            if (ad.getName().equals(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName())) {
                MessageCounterEnabledHandler handler = new MessageCounterEnabledHandler();
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_ENABLED, (OperationStepHandler)handler, (OperationStepHandler)handler);
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(ad, null, (OperationStepHandler)writeHandler);
        }
        resourceRegistration.registerReadWriteAttribute(CommonAttributes.LIVE_CONNECTOR_REF, null, DeprecatedAttributeWriteHandler.INSTANCE);
    }

    private static final class ClusteredAttributeHandlers {
        static final OperationStepHandler READ_HANDLER = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                boolean clustered = ClusteredAttributeHandlers.isClustered(context);
                context.getResult().set(clustered);
            }
        };
        static final OperationStepHandler WRITE_HANDLER = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                boolean clustered = ClusteredAttributeHandlers.isClustered(context);
                ModelNode mock = new ModelNode();
                mock.get(CommonAttributes.CLUSTERED.getName()).set(operation.get("value"));
                boolean wantsClustered = CommonAttributes.CLUSTERED.resolveModelAttribute(context, mock).asBoolean();
                if (clustered && !wantsClustered) {
                    PathAddress serverAddress = context.getCurrentAddress();
                    MessagingLogger.ROOT_LOGGER.warn(MessagingLogger.ROOT_LOGGER.canNotChangeClusteredAttribute(serverAddress));
                }
                context.stepCompleted();
            }
        };

        private ClusteredAttributeHandlers() {
        }

        private static boolean isClustered(OperationContext context) {
            Set clusterConnectionNames = context.readResource(PathAddress.EMPTY_ADDRESS).getChildrenNames(ClusterConnectionDefinition.PATH.getKey());
            return !clusterConnectionNames.isEmpty();
        }
    }

    private static class MessageCounterEnabledHandler
    implements OperationStepHandler {
        private MessageCounterEnabledHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode aliased = MessageCounterEnabledHandler.getAliasedOperation(operation);
            context.addStep(aliased, MessageCounterEnabledHandler.getHandlerForOperation(context, operation), OperationContext.Stage.MODEL, true);
        }

        private static ModelNode getAliasedOperation(ModelNode operation) {
            ModelNode aliased = operation.clone();
            aliased.get("name").set(CommonAttributes.STATISTICS_ENABLED.getName());
            return aliased;
        }

        private static OperationStepHandler getHandlerForOperation(OperationContext context, ModelNode operation) {
            ImmutableManagementResourceRegistration imrr = context.getResourceRegistration();
            return imrr.getOperationHandler(PathAddress.EMPTY_ADDRESS, operation.get("operation").asString());
        }
    }
}

