/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.memcached.MemcachedExpirableMetadata;
import org.infinispan.server.memcached.MemcachedMetadataBuilder;
import org.jboss.marshalling.util.IdentityIntMap;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001-\u0011\u0011#T3nG\u0006\u001c\u0007.\u001a3NKR\fG-\u0019;b\u0015\t\u0019A!A\u0005nK6\u001c\u0017m\u00195fI*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011AC5oM&t\u0017n\u001d9b]*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\t\u0001\"\\3uC\u0012\fG/Y\u0005\u00033Y\u0011\u0001\"T3uC\u0012\fG/\u0019\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005)a\r\\1hgV\tQ\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0003M_:<\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\r\u0019d\u0017mZ:!\u0011!1\u0003A!b\u0001\n\u00039\u0013a\u0002<feNLwN\\\u000b\u0002QA\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u000bm\u0016\u00148/[8oS:<'BA\u0017\u0007\u0003%\u0019wN\u001c;bS:,'/\u0003\u00020U\taQI\u001c;ssZ+'o]5p]\"A\u0011\u0007\u0001B\u0001B\u0003%\u0001&\u0001\u0005wKJ\u001c\u0018n\u001c8!\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q\u0019Qg\u000e\u001d\u0011\u0005Y\u0002Q\"\u0001\u0002\t\u000bm\u0011\u0004\u0019A\u000f\t\u000b\u0019\u0012\u0004\u0019\u0001\u0015\t\u000bi\u0002A\u0011A\u001e\u0002\u00111Lg-Z:qC:$\u0012!\b\u0005\u0006{\u0001!\taO\u0001\b[\u0006D\u0018\n\u001a7f\u0011\u0015y\u0004\u0001\"\u0001A\u0003\u001d\u0011W/\u001b7eKJ$\u0012!\u0011\t\u0003\u0005\u0016s!!F\"\n\u0005\u00113\u0012\u0001C'fi\u0006$\u0017\r^1\n\u0005\u0019;%a\u0002\"vS2$WM\u001d\u0006\u0003\tZAQ!\u0013\u0001\u0005B)\u000ba!Z9vC2\u001cHCA&O!\tqB*\u0003\u0002N?\t9!i\\8mK\u0006t\u0007\"B(I\u0001\u0004\u0001\u0016aA8cUB\u0011a$U\u0005\u0003%~\u00111!\u00118z\u0011\u0015!\u0006\u0001\"\u0001V\u0003!\u0019\u0017M\\#rk\u0006dGCA&W\u0011\u001596\u000b1\u0001Q\u0003\u0015yG\u000f[3s\u0011\u0015I\u0006\u0001\"\u0011[\u0003!A\u0017m\u001d5D_\u0012,G#A.\u0011\u0005ya\u0016BA/ \u0005\rIe\u000e\u001e\u0005\u0006?\u0002!\t\u0005Y\u0001\ti>\u001cFO]5oOR\t\u0011\r\u0005\u0002cK:\u0011adY\u0005\u0003I~\ta\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011AmH\u0004\u0006S\nA\tA[\u0001\u0012\u001b\u0016l7-Y2iK\u0012lU\r^1eCR\f\u0007C\u0001\u001cl\r\u0015\t!\u0001#\u0001m'\tYW\u000e\u0005\u0002\u001f]&\u0011qn\b\u0002\u0007\u0003:L(+\u001a4\t\u000bMZG\u0011A9\u0015\u0003)4Aa]6\u0001i\naQ\t\u001f;fe:\fG.\u001b>feN\u0011!/\u001e\t\u0004mn,T\"A<\u000b\u0005aL\u0018\u0001C7beND\u0017\r\u001c7\u000b\u0005i4\u0011aB2p[6|gn]\u0005\u0003y^\u0014A#\u00112tiJ\f7\r^#yi\u0016\u0014h.\u00197ju\u0016\u0014\b\"B\u001as\t\u0003qH#A@\u0011\u0007\u0005\u0005!/D\u0001l\u0011%\t)A\u001db\u0001\n\u000b\t9!\u0001\u0005J[6|'\u000f^1m+\t\tIa\u0004\u0002\u0002\fu\t\u0001\u0001\u0003\u0005\u0002\u0010I\u0004\u000bQBA\u0005\u0003%IU.\\8si\u0006d\u0007\u0005C\u0005\u0002\u0014I\u0014\r\u0011\"\u0002\u0002\u0016\u0005IQ\t\u001f9je\u0006\u0014G.Z\u000b\u0003\u0003/y!!!\u0007\u001e\u0003\u0005A\u0001\"!\bsA\u00035\u0011qC\u0001\u000b\u000bb\u0004\u0018N]1cY\u0016\u0004\u0003\"CA\u0011e\n\u0007IQAA\u0012\u0003\u001dqW/\u001c2feN,\"!!\n\u0011\r\u0005\u001d\u0012QGA\u001d\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001B;uS2TA!a\f\u00022\u0005YQ.\u0019:tQ\u0006dG.\u001b8h\u0015\r\t\u0019\u0004C\u0001\u0006U\n|7o]\u0005\u0005\u0003o\tIC\u0001\bJI\u0016tG/\u001b;z\u0013:$X*\u001991\t\u0005m\u0012Q\t\t\u0006\u001b\u0005u\u0012\u0011I\u0005\u0004\u0003\u007fq!!B\"mCN\u001c\b\u0003BA\"\u0003\u000bb\u0001\u0001\u0002\u0007\u0002H\u0005%\u0013\u0011!A\u0001\u0006\u0003\tiEA\u0002`IEB\u0001\"a\u0013sA\u00035\u0011QE\u0001\t]Vl'-\u001a:tAE\u0019\u0011q\n)\u0011\u0007y\t\t&C\u0002\u0002T}\u0011qAT8uQ&tw\rC\u0004\u0002XI$\t!!\u0017\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG\u000fF\u00026\u00037B\u0001\"!\u0018\u0002V\u0001\u0007\u0011qL\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011Q\r\t\u0002\u0005%|\u0017\u0002BA5\u0003G\u00121b\u00142kK\u000e$\u0018J\u001c9vi\"9\u0011Q\u000e:\u0005\u0002\u0005=\u0014aC<sSR,wJ\u00196fGR$b!!\u001d\u0002x\u0005\u0005\u0005c\u0001\u0010\u0002t%\u0019\u0011QO\u0010\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003s\nY\u00071\u0001\u0002|\u00051q.\u001e;qkR\u0004B!!\u0019\u0002~%!\u0011qPA2\u00051y%M[3di>+H\u000f];u\u0011\u001d\t\u0019)a\u001bA\u0002U\nA!\\3uC\"9\u0011q\u0011:\u0005\u0002\u0005%\u0015AD4fiRK\b/Z\"mCN\u001cXm\u001d\u000b\u0003\u0003\u0017\u0003b!!$\u0002\u0012\u0006UUBAAH\u0015\r\tY\u0003E\u0005\u0005\u0003'\u000byIA\u0002TKR\u0004D!a&\u0002\u001eB)!-!'\u0002\u001c&\u0019\u0011qH4\u0011\t\u0005\r\u0013Q\u0014\u0003\r\u0003?\u000b))!A\u0001\u0002\u000b\u0005\u0011\u0011\u0015\u0002\u0004?\u0012\u0012\u0014cAA(k\u0001")
public class MemcachedMetadata
implements Metadata {
    private final long flags;
    private final EntryVersion version;

    public long flags() {
        return this.flags;
    }

    public EntryVersion version() {
        return this.version;
    }

    public long lifespan() {
        return -1L;
    }

    public long maxIdle() {
        return -1L;
    }

    public Metadata.Builder builder() {
        return new MemcachedMetadataBuilder().flags(this.flags()).version(this.version());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof MemcachedMetadata)) return false;
        MemcachedMetadata memcachedMetadata = (MemcachedMetadata)object;
        if (!memcachedMetadata.canEqual(this)) return false;
        if (this.flags() != memcachedMetadata.flags()) return false;
        EntryVersion entryVersion = this.version();
        EntryVersion entryVersion2 = memcachedMetadata.version();
        if (entryVersion != null) {
            if (!entryVersion.equals(entryVersion2)) return false;
            return true;
        }
        if (entryVersion2 == null) return true;
        return false;
    }

    public boolean canEqual(Object other) {
        return other instanceof MemcachedMetadata;
    }

    public int hashCode() {
        return 41 * (41 + ((Object)BoxesRunTime.boxToLong((long)this.flags())).hashCode()) + this.version().hashCode();
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MemcachedMetadata(flags=", ", version=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.flags()), this.version()}));
    }

    public MemcachedMetadata(long flags, EntryVersion version) {
        this.flags = flags;
        this.version = version;
    }

    public static class Externalizer
    extends AbstractExternalizer<MemcachedMetadata> {
        private final int Immortal;
        private final int Expirable;
        private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(2);

        public final int Immortal() {
            return 0;
        }

        public final int Expirable() {
            return 1;
        }

        public final IdentityIntMap<Class<?>> numbers() {
            return this.numbers;
        }

        public MemcachedMetadata readObject(ObjectInput input) {
            MemcachedMetadata memcachedMetadata;
            int number;
            long flags = input.readLong();
            EntryVersion version = (EntryVersion)input.readObject();
            int n = number = input.readUnsignedByte();
            switch (n) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
                case 1: {
                    long lifespan = input.readLong();
                    memcachedMetadata = new MemcachedExpirableMetadata(flags, version, lifespan, TimeUnit.MILLISECONDS);
                    break;
                }
                case 0: {
                    memcachedMetadata = new MemcachedMetadata(flags, version);
                }
            }
            return memcachedMetadata;
        }

        public void writeObject(ObjectOutput output, MemcachedMetadata meta) {
            output.writeLong(meta.flags());
            output.writeObject(meta.version());
            int number = this.numbers().get(meta.getClass(), -1);
            output.write(number);
            if (number == 1) {
                output.writeLong(meta.lifespan());
            }
        }

        public java.util.Set<Class<? extends MemcachedMetadata>> getTypeClasses() {
            return JavaConversions$.MODULE$.setAsJavaSet((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{MemcachedMetadata.class, MemcachedExpirableMetadata.class})));
        }

        public Externalizer() {
            this.numbers().put(MemcachedMetadata.class, 0);
            this.numbers().put(MemcachedExpirableMetadata.class, 1);
        }
    }
}

