/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.server.endpoint.subsystem.Attribute;
import org.infinispan.server.endpoint.subsystem.AuthenticationResource;
import org.infinispan.server.endpoint.subsystem.CommonConnectorResource;
import org.infinispan.server.endpoint.subsystem.Element;
import org.infinispan.server.endpoint.subsystem.EncryptionResource;
import org.infinispan.server.endpoint.subsystem.MemcachedConnectorResource;
import org.infinispan.server.endpoint.subsystem.Namespace;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestConnectorResource;
import org.infinispan.server.endpoint.subsystem.SaslPolicyResource;
import org.infinispan.server.endpoint.subsystem.SaslResource;
import org.infinispan.server.endpoint.subsystem.TopologyStateTransferResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class EndpointSubsystemWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    EndpointSubsystemWriter() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode node = context.getModelNode();
        this.writeConnectors(writer, node);
        writer.writeEndElement();
    }

    private void writeConnectors(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        for (Property property : this.getConnectorsByType(node, "hotrod-connector")) {
            this.writeHotRodConnector(writer, property.getValue());
        }
        for (Property property : this.getConnectorsByType(node, "memcached-connector")) {
            this.writeMemcachedConnector(writer, property.getValue());
        }
        for (Property property : this.getConnectorsByType(node, "rest-connector")) {
            this.writeRestConnector(writer, property.getValue());
        }
        for (Property property : this.getConnectorsByType(node, "websocket-connector")) {
            this.writeWebSocketConnector(writer, property.getValue());
        }
    }

    private List<Property> getConnectorsByType(ModelNode node, String connectorType) {
        if (node.hasDefined(connectorType)) {
            ModelNode connectors = node.get(connectorType);
            return connectors.asPropertyList();
        }
        return Collections.emptyList();
    }

    private void writeHotRodConnector(XMLExtendedStreamWriter writer, ModelNode connector) throws XMLStreamException {
        writer.writeStartElement(Element.HOTROD_CONNECTOR.getLocalName());
        this.writeCommonConnector(writer, connector);
        this.writeProtocolServerConnector(writer, connector);
        this.writeTopologyStateTransfer(writer, connector);
        this.writeAuthentication(writer, connector);
        this.writeEncryption(writer, connector);
        writer.writeEndElement();
    }

    private void writeMemcachedConnector(XMLExtendedStreamWriter writer, ModelNode connector) throws XMLStreamException {
        writer.writeStartElement(Element.MEMCACHED_CONNECTOR.getLocalName());
        this.writeCommonConnector(writer, connector);
        this.writeProtocolServerConnector(writer, connector);
        for (SimpleAttributeDefinition attribute : MemcachedConnectorResource.MEMCACHED_CONNECTOR_ATTRIBUTES) {
            attribute.marshallAsAttribute(connector, true, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    private void writeRestConnector(XMLExtendedStreamWriter writer, ModelNode connector) throws XMLStreamException {
        writer.writeStartElement(Element.REST_CONNECTOR.getLocalName());
        this.writeCommonConnector(writer, connector);
        for (SimpleAttributeDefinition attribute : RestConnectorResource.REST_ATTRIBUTES) {
            attribute.marshallAsAttribute(connector, true, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    private void writeWebSocketConnector(XMLExtendedStreamWriter writer, ModelNode connector) throws XMLStreamException {
        writer.writeStartElement(Element.WEBSOCKET_CONNECTOR.getLocalName());
        this.writeCommonConnector(writer, connector);
        this.writeProtocolServerConnector(writer, connector);
        writer.writeEndElement();
    }

    private void writeCommonConnector(XMLExtendedStreamWriter writer, ModelNode connector) throws XMLStreamException {
        for (SimpleAttributeDefinition attribute : CommonConnectorResource.COMMON_CONNECTOR_ATTRIBUTES) {
            attribute.marshallAsAttribute(connector, true, (XMLStreamWriter)writer);
        }
        SimpleListAttributeDefinition ignoredCaches = CommonConnectorResource.IGNORED_CACHES;
        this.writeListAsAttribute(writer, ignoredCaches.getXmlName(), connector, ignoredCaches.getName());
    }

    private void writeProtocolServerConnector(XMLExtendedStreamWriter writer, ModelNode connector) throws XMLStreamException {
        for (SimpleAttributeDefinition attribute : ProtocolServerConnectorResource.PROTOCOL_SERVICE_ATTRIBUTES) {
            attribute.marshallAsAttribute(connector, true, (XMLStreamWriter)writer);
        }
    }

    private void writeTopologyStateTransfer(XMLExtendedStreamWriter writer, ModelNode connector) throws XMLStreamException {
        if (connector.hasDefined("topology-state-transfer")) {
            ModelNode topologyStateTransfer = connector.get(new String[]{"topology-state-transfer", "TOPOLOGY_STATE_TRANSFER"});
            writer.writeStartElement(Element.TOPOLOGY_STATE_TRANSFER.getLocalName());
            for (SimpleAttributeDefinition attribute : TopologyStateTransferResource.TOPOLOGY_ATTRIBUTES) {
                attribute.marshallAsAttribute(topologyStateTransfer, true, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
    }

    private void writeAuthentication(XMLExtendedStreamWriter writer, ModelNode connector) throws XMLStreamException {
        if (connector.hasDefined("authentication")) {
            ModelNode authentication = connector.get(new String[]{"authentication", "AUTHENTICATION"});
            writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
            for (SimpleAttributeDefinition attribute : AuthenticationResource.AUTHENTICATION_ATTRIBUTES) {
                attribute.marshallAsAttribute(authentication, true, (XMLStreamWriter)writer);
            }
            this.writeSasl(writer, authentication);
            writer.writeEndElement();
        }
    }

    private void writeSasl(XMLExtendedStreamWriter writer, ModelNode authentication) throws XMLStreamException {
        if (authentication.hasDefined("sasl")) {
            ModelNode sasl = authentication.get(new String[]{"sasl", "SASL"});
            writer.writeStartElement(Element.SASL.getLocalName());
            for (AttributeDefinition attribute : SaslResource.SASL_ATTRIBUTES) {
                if (attribute instanceof SimpleAttributeDefinition) {
                    ((SimpleAttributeDefinition)attribute).marshallAsAttribute(sasl, true, (XMLStreamWriter)writer);
                    continue;
                }
                if (!(attribute instanceof StringListAttributeDefinition)) continue;
                this.writeListAsAttribute(writer, attribute.getXmlName(), sasl, attribute.getName());
            }
            this.writePolicy(writer, sasl);
            this.writeProperties(writer, sasl);
            writer.writeEndElement();
        }
    }

    private void writePolicy(XMLExtendedStreamWriter writer, ModelNode sasl) throws XMLStreamException {
        if (sasl.hasDefined("sasl-policy")) {
            ModelNode policy = sasl.get(new String[]{"sasl-policy", "SASL_POLICY"});
            writer.writeStartElement(Element.POLICY.getLocalName());
            SaslPolicyResource.FORWARD_SECRECY.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.NO_ACTIVE.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.NO_ANONYMOUS.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.NO_DICTIONARY.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.NO_PLAIN_TEXT.marshallAsElement(policy, (XMLStreamWriter)writer);
            SaslPolicyResource.PASS_CREDENTIALS.marshallAsElement(policy, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeProperties(XMLExtendedStreamWriter writer, ModelNode sasl) throws XMLStreamException {
        if (sasl.hasDefined("property")) {
            for (Property property : sasl.get("property").asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                Property complexValue = property.getValue().asProperty();
                writer.writeCharacters(complexValue.getValue().asString());
                writer.writeEndElement();
            }
        }
    }

    private void writeEncryption(XMLExtendedStreamWriter writer, ModelNode connector) throws XMLStreamException {
        if (connector.hasDefined("encryption")) {
            ModelNode encryption = connector.get(new String[]{"encryption", "ENCRYPTION"});
            writer.writeStartElement(Element.ENCRYPTION.getLocalName());
            for (SimpleAttributeDefinition attribute : EncryptionResource.ENCRYPTION_ATTRIBUTES) {
                attribute.marshallAsAttribute(encryption, true, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
    }

    private void writeListAsAttribute(XMLExtendedStreamWriter writer, String attributeName, ModelNode node, String key) throws XMLStreamException {
        if (node.hasDefined(key)) {
            StringBuilder result = new StringBuilder();
            ModelNode list = node.get(key);
            if (list.isDefined() && list.getType() == ModelType.LIST) {
                List nodeList = list.asList();
                for (int i = 0; i < nodeList.size(); ++i) {
                    result.append(((ModelNode)nodeList.get(i)).asString());
                    if (i >= nodeList.size() - 1) continue;
                    result.append(" ");
                }
                writer.writeAttribute(attributeName, result.toString());
            }
        }
    }
}

