/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConfigurationUtil;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public class BackupManager
implements ActiveMQComponent {
    private ActiveMQServer server;
    private Executor executor;
    private ScheduledExecutorService scheduledExecutor;
    private NodeManager nodeManager;
    private Configuration configuration;
    private ClusterManager clusterManager;
    List<BackupConnector> backupConnectors = new ArrayList<BackupConnector>();
    private boolean started;

    public BackupManager(ActiveMQServer server, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutor, NodeManager nodeManager, Configuration configuration, ClusterManager clusterManager) {
        this.server = server;
        this.executor = executorFactory.getExecutor();
        this.scheduledExecutor = scheduledExecutor;
        this.nodeManager = nodeManager;
        this.configuration = configuration;
        this.clusterManager = clusterManager;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        for (ClusterConnectionConfiguration config : this.configuration.getClusterConfigurations()) {
            this.deployBackupConnector(config);
        }
        for (BackupConnector conn : this.backupConnectors) {
            conn.start();
            if (!this.server.getHAPolicy().isBackup() || !this.server.getHAPolicy().isSharedStore()) continue;
            conn.informTopology();
            conn.announceBackup();
        }
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        for (BackupConnector backupConnector : this.backupConnectors) {
            backupConnector.close();
        }
        this.started = false;
    }

    public void announceBackup() {
        for (BackupConnector backupConnector : this.backupConnectors) {
            backupConnector.announceBackup();
        }
    }

    private void deployBackupConnector(ClusterConnectionConfiguration config) {
        TransportConfiguration connector = ClusterConfigurationUtil.getTransportConfiguration(config, this.configuration);
        if (connector == null) {
            return;
        }
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = ClusterConfigurationUtil.getDiscoveryGroupConfiguration(config, this.configuration);
            if (dg == null) {
                return;
            }
            DiscoveryBackupConnector backupConnector = new DiscoveryBackupConnector(dg, config.getName(), connector, config.getRetryInterval(), this.clusterManager);
            this.backupConnectors.add(backupConnector);
        } else {
            TransportConfiguration[] tcConfigs = ClusterConfigurationUtil.getTransportConfigurations(config, this.configuration);
            StaticBackupConnector backupConnector = new StaticBackupConnector(tcConfigs, config.getName(), connector, config.getRetryInterval(), this.clusterManager);
            this.backupConnectors.add(backupConnector);
        }
    }

    public void activated() {
        for (BackupConnector backupConnector : this.backupConnectors) {
            backupConnector.close();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isBackupAnnounced() {
        for (BackupConnector backupConnector : this.backupConnectors) {
            if (backupConnector.isBackupAnnounced()) continue;
            return false;
        }
        return true;
    }

    private final class DiscoveryBackupConnector
    extends BackupConnector {
        private final DiscoveryGroupConfiguration discoveryGroupConfiguration;

        public DiscoveryBackupConnector(DiscoveryGroupConfiguration discoveryGroupConfiguration, String name, TransportConfiguration connector, long retryInterval, ClusterManager clusterManager) {
            super(name, connector, retryInterval, clusterManager);
            this.discoveryGroupConfiguration = discoveryGroupConfiguration;
        }

        @Override
        public ServerLocatorInternal createServerLocator(Topology topology) {
            return new ServerLocatorImpl(topology, true, this.discoveryGroupConfiguration);
        }

        public String toString() {
            return "DiscoveryBackupConnector [group=" + this.discoveryGroupConfiguration + "]";
        }
    }

    private final class StaticBackupConnector
    extends BackupConnector {
        private final TransportConfiguration[] tcConfigs;

        public StaticBackupConnector(TransportConfiguration[] tcConfigs, String name, TransportConfiguration connector, long retryInterval, ClusterManager clusterManager) {
            super(name, connector, retryInterval, clusterManager);
            this.tcConfigs = tcConfigs;
        }

        @Override
        public ServerLocatorInternal createServerLocator(Topology topology) {
            if (this.tcConfigs != null && this.tcConfigs.length > 0) {
                if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug(BackupManager.this + "Creating a serverLocator for " + Arrays.toString(this.tcConfigs));
                }
                ServerLocatorImpl locator = new ServerLocatorImpl(topology, true, this.tcConfigs);
                locator.setClusterConnection(true);
                locator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)locator));
                return locator;
            }
            return null;
        }

        public String toString() {
            return "StaticBackupConnector [tcConfigs=" + Arrays.toString(this.tcConfigs) + "]";
        }
    }

    private abstract class BackupConnector {
        private volatile ServerLocatorInternal backupServerLocator;
        private String name;
        private TransportConfiguration connector;
        private long retryInterval;
        private ClusterManager clusterManager;
        private boolean stopping = false;
        private boolean announcingBackup;
        private boolean backupAnnounced = false;

        public BackupConnector(String name, TransportConfiguration connector, long retryInterval, ClusterManager clusterManager) {
            this.name = name;
            this.connector = connector;
            this.retryInterval = retryInterval;
            this.clusterManager = clusterManager;
        }

        abstract ServerLocatorInternal createServerLocator(Topology var1);

        void start() {
            this.stopping = false;
            this.backupAnnounced = false;
            ClusterConnection clusterConnection = this.clusterManager.getClusterConnection(this.name);
            this.backupServerLocator = this.createServerLocator(clusterConnection.getTopology());
            if (this.backupServerLocator != null) {
                this.backupServerLocator.setIdentity("backupLocatorFor='" + BackupManager.this.server + "'");
                this.backupServerLocator.setReconnectAttempts(-1);
                this.backupServerLocator.setInitialConnectAttempts(-1);
                this.backupServerLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)this.backupServerLocator));
            }
        }

        public void announceBackup() {
            BackupManager.this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (BackupConnector.this.stopping) {
                        return;
                    }
                    try {
                        ServerLocatorInternal localBackupLocator = BackupConnector.this.backupServerLocator;
                        if (localBackupLocator == null) {
                            if (!BackupConnector.this.stopping) {
                                ActiveMQServerLogger.LOGGER.error("Error announcing backup: backupServerLocator is null. " + this);
                            }
                            return;
                        }
                        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                            ActiveMQServerLogger.LOGGER.debug(BackupConnector.this + ":: announcing " + BackupConnector.this.connector + " to " + BackupConnector.this.backupServerLocator);
                        }
                        BackupConnector.this.announcingBackup = true;
                        ClientSessionFactoryInternal backupSessionFactory = localBackupLocator.connect();
                        if (backupSessionFactory != null) {
                            ClusterControl clusterControl = BackupConnector.this.clusterManager.getClusterController().connectToNodeInCluster(backupSessionFactory);
                            clusterControl.authorize();
                            clusterControl.sendNodeAnnounce(System.currentTimeMillis(), BackupManager.this.nodeManager.getNodeId().toString(), BackupManager.this.server.getHAPolicy().getBackupGroupName(), BackupManager.this.server.getHAPolicy().getScaleDownClustername(), true, BackupConnector.this.connector, null);
                            ActiveMQServerLogger.LOGGER.backupAnnounced();
                            BackupConnector.this.backupAnnounced = true;
                        }
                    }
                    catch (RejectedExecutionException e) {
                    }
                    catch (Exception e) {
                        if (BackupManager.this.scheduledExecutor.isShutdown()) {
                            return;
                        }
                        if (BackupConnector.this.stopping) {
                            return;
                        }
                        ActiveMQServerLogger.LOGGER.errorAnnouncingBackup();
                        BackupManager.this.scheduledExecutor.schedule(new Runnable(){

                            @Override
                            public void run() {
                                BackupConnector.this.announceBackup();
                            }
                        }, BackupConnector.this.retryInterval, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        BackupConnector.this.announcingBackup = false;
                    }
                }
            });
        }

        public void informTopology() {
            this.clusterManager.informClusterOfBackup(this.name);
        }

        public void close() {
            this.stopping = true;
            if (this.announcingBackup) {
                this.closeLocator(this.backupServerLocator);
            }
            BackupManager.this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BackupConnector backupConnector = BackupConnector.this;
                    synchronized (backupConnector) {
                        BackupConnector.this.closeLocator(BackupConnector.this.backupServerLocator);
                        BackupConnector.this.backupServerLocator = null;
                    }
                }
            });
        }

        public boolean isBackupAnnounced() {
            return this.backupAnnounced;
        }

        private void closeLocator(ServerLocatorInternal backupServerLocator) {
            if (backupServerLocator != null) {
                backupServerLocator.close();
            }
        }
    }
}

