/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;

class DefaultErrorHandler
implements ErrorHandler {
    DefaultErrorHandler() {
    }

    @Override
    public void jspError(String fname, int line, int column, String errMsg, Exception ex) throws JasperException {
        throw new JasperException(fname + " (" + JasperMessages.MESSAGES.errorInJspFileLineColumn(line, column) + ") " + errMsg, ex);
    }

    @Override
    public void jspError(String errMsg, Exception ex) throws JasperException {
        throw new JasperException(errMsg, ex);
    }

    @Override
    public void javacError(JavacErrorDetail[] details) throws JasperException {
        if (details == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < details.length; ++i) {
            if (details[i].getJspBeginLineNumber() >= 0) {
                buf.append(System.lineSeparator());
                buf.append(System.lineSeparator());
                buf.append(JasperMessages.MESSAGES.errorInJspFile(details[i].getJspBeginLineNumber(), details[i].getJspFileName()));
                buf.append(System.lineSeparator());
                buf.append(details[i].getErrorMessage());
                buf.append(System.lineSeparator());
                buf.append(details[i].getJspExtract());
                continue;
            }
            buf.append(System.lineSeparator());
            buf.append(System.lineSeparator());
            buf.append(JasperMessages.MESSAGES.errorInJavaFile(details[i].getJavaLineNumber()));
            buf.append(System.lineSeparator());
            buf.append(details[i].getErrorMessage());
        }
        buf.append(System.lineSeparator());
        buf.append(System.lineSeparator());
        buf.append("Stacktrace:");
        throw new JasperException(JasperMessages.MESSAGES.failedClassCompilation(buf.toString()));
    }

    @Override
    public void javacError(String errorReport, Exception exception) throws JasperException {
        throw new JasperException(JasperMessages.MESSAGES.failedClassCompilation(), exception);
    }
}

