/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBean;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;

public class InfinispanBeanFactory<G, I, T>
implements BeanFactory<G, I, T> {
    private final String beanName;
    private final BeanGroupFactory<G, I, T> groupFactory;
    private final Cache<BeanKey<I>, BeanEntry<G>> cache;
    private final Time timeout;
    private final PassivationListener<T> listener;

    public InfinispanBeanFactory(String beanName, BeanGroupFactory<G, I, T> groupFactory, Cache<BeanKey<I>, BeanEntry<G>> beanCache, Time timeout, PassivationListener<T> listener) {
        this.beanName = beanName;
        this.groupFactory = groupFactory;
        this.cache = beanCache;
        this.timeout = timeout;
        this.listener = listener;
    }

    @Override
    public BeanKey<I> createKey(I id) {
        return new InfinispanBeanKey<I>(this.beanName, id);
    }

    @Override
    public Bean<G, I, T> createBean(I id, BeanEntry<G> entry) {
        G groupId = entry.getGroupId();
        BeanGroupEntry groupEntry = (BeanGroupEntry)this.groupFactory.findValue(groupId);
        if (groupEntry == null) {
            throw InfinispanEjbLogger.ROOT_LOGGER.invalidBeanGroup(id, groupId);
        }
        BeanGroup<G, I, T> group = this.groupFactory.createGroup(groupId, groupEntry);
        Mutator mutator = entry.getLastAccessedTime() == null ? Mutator.PASSIVE : new CacheEntryMutator(this.cache, this.createKey(id), entry);
        return new InfinispanBean<G, I, T>(id, entry, group, mutator, this, this.timeout, this.listener);
    }

    public BeanEntry<G> findValue(I id) {
        return (BeanEntry)this.cache.get(this.createKey(id));
    }

    public BeanEntry<G> createValue(I id, G groupId) {
        return (BeanEntry)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).computeIfAbsent(this.createKey(id), key -> new InfinispanBeanEntry<Object>(groupId));
    }

    @Override
    public void remove(I id, RemoveListener<T> listener) {
        BeanEntry entry = (BeanEntry)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove(this.createKey(id));
        if (entry != null) {
            Object groupId = entry.getGroupId();
            try (BeanGroup<G, I, T> group = this.groupFactory.createGroup(groupId, (BeanGroupEntry)this.groupFactory.findValue(groupId));){
                T bean = group.removeBean(id);
                if (listener != null) {
                    listener.removed(bean);
                }
            }
        }
    }

    public void evict(I id) {
        BeanKey<I> key = this.createKey(id);
        BeanEntry entry = (BeanEntry)this.cache.get(key);
        if (entry != null) {
            try {
                this.cache.evict(key);
            }
            catch (Throwable e) {
                InfinispanEjbLogger.ROOT_LOGGER.failedToPassivateBean(e, id);
            }
            this.groupFactory.evict(entry.getGroupId());
        }
    }
}

