/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ProducerConsumerQueue<T> {
    private static final int DEFAULT_BUFF_LENGTH = 1000;
    private static final Object exitToken = new Object();
    private final BlockingQueue<Object> queue;
    private final AtomicInteger producersToWaitFor;

    public ProducerConsumerQueue(int producersToWaitFor) {
        this(1000, producersToWaitFor);
    }

    public ProducerConsumerQueue(int queueLength, int producersToWaitFor) {
        this.queue = new ArrayBlockingQueue<Object>(queueLength);
        this.producersToWaitFor = new AtomicInteger(producersToWaitFor);
    }

    public T take() throws InterruptedException {
        Object obj = this.queue.take();
        if (obj == exitToken) {
            this.queue.put(exitToken);
            return null;
        }
        return (T)obj;
    }

    public void put(T obj) throws InterruptedException {
        this.queue.put(obj);
    }

    public void producerStopping() {
        int activeProducers = this.producersToWaitFor.decrementAndGet();
        if (activeProducers == 0) {
            try {
                this.queue.put(exitToken);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

