/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilder;
import org.jboss.as.webservices.deployers.deployment.JandexAnnotationsInfo;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.VirtualFileAdaptor;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.AnnotationsInfo;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointType;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

abstract class AbstractDeploymentModelBuilder
implements DeploymentModelBuilder {
    private final DeploymentModelFactory deploymentModelFactory;
    private final EndpointType endpointType;

    protected AbstractDeploymentModelBuilder(EndpointType endpointType) {
        ClassLoader cl = AbstractDeploymentModelBuilder.class.getClassLoader();
        SPIProvider spiProvider = SPIProviderResolver.getInstance((ClassLoader)cl).getProvider();
        this.deploymentModelFactory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class, cl);
        this.endpointType = endpointType;
    }

    @Override
    public final void newDeploymentModel(DeploymentUnit unit) {
        ArchiveDeployment dep;
        if (unit.hasAttachment(WSAttachmentKeys.DEPLOYMENT_KEY)) {
            dep = (ArchiveDeployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
        } else {
            dep = this.newDeployment(unit);
            this.propagateAttachments(unit, dep);
        }
        this.build((Deployment)dep, unit);
    }

    private void propagateAttachments(DeploymentUnit unit, ArchiveDeployment dep) {
        dep.addAttachment(DeploymentUnit.class, (Object)unit);
        unit.putAttachment(WSAttachmentKeys.DEPLOYMENT_KEY, (Object)dep);
        JBossWebMetaData webMD = ASHelper.getJBossWebMetaData(unit);
        dep.addAttachment(JBossWebMetaData.class, (Object)webMD);
        WebservicesMetaData webservicesMD = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.WEBSERVICES_METADATA_KEY);
        dep.addAttachment(WebservicesMetaData.class, (Object)webservicesMD);
        JBossWebservicesMetaData jbossWebservicesMD = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JBOSS_WEBSERVICES_METADATA_KEY);
        if (unit.getParent() != null) {
            jbossWebservicesMD = JBossWebservicesMetaData.merge((JBossWebservicesMetaData)ASHelper.getOptionalAttachment(unit.getParent(), WSAttachmentKeys.JBOSS_WEBSERVICES_METADATA_KEY), (JBossWebservicesMetaData)jbossWebservicesMD);
        }
        dep.addAttachment(JBossWebservicesMetaData.class, (Object)jbossWebservicesMD);
        JAXWSDeployment jaxwsDeployment = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        dep.addAttachment(JAXWSDeployment.class, (Object)jaxwsDeployment);
        EjbJarMetaData ejbJarMD = (EjbJarMetaData)ASHelper.getOptionalAttachment(unit, EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        dep.addAttachment(EjbJarMetaData.class, (Object)ejbJarMD);
    }

    protected abstract void build(Deployment var1, DeploymentUnit var2);

    protected final Endpoint newHttpEndpoint(String endpointClass, String endpointName, Deployment dep) {
        if (endpointName == null) {
            throw WSLogger.ROOT_LOGGER.nullEndpointName();
        }
        if (endpointClass == null) {
            throw WSLogger.ROOT_LOGGER.nullEndpointClass();
        }
        Endpoint endpoint = this.deploymentModelFactory.newHttpEndpoint(endpointClass);
        endpoint.setShortName(endpointName);
        endpoint.setType(this.endpointType);
        dep.getService().addEndpoint(endpoint);
        return endpoint;
    }

    protected final Endpoint newJMSEndpoint(String endpointClass, String endpointName, String soapAddress, Deployment dep) {
        if (endpointName == null) {
            throw WSLogger.ROOT_LOGGER.nullEndpointName();
        }
        if (endpointClass == null) {
            throw WSLogger.ROOT_LOGGER.nullEndpointClass();
        }
        Endpoint endpoint = this.deploymentModelFactory.newJMSEndpoint(endpointClass);
        endpoint.setAddress(soapAddress);
        endpoint.setShortName(endpointName);
        endpoint.setType(this.endpointType);
        dep.getService().addEndpoint(endpoint);
        return endpoint;
    }

    private ArchiveDeployment newDeployment(DeploymentUnit unit) {
        Object classLoader;
        WSLogger.ROOT_LOGGER.tracef("Creating new unified WS deployment model for %s", unit);
        ResourceRoot deploymentRoot = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile root = deploymentRoot != null ? deploymentRoot.getRoot() : null;
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        if (module == null) {
            classLoader = (ClassLoader)unit.getAttachment(WSAttachmentKeys.CLASSLOADER_KEY);
            if (classLoader == null) {
                throw WSLogger.ROOT_LOGGER.classLoaderResolutionFailed(unit);
            }
        } else {
            classLoader = module.getClassLoader();
        }
        ArchiveDeployment parentDep = null;
        if (unit.getParent() != null) {
            Module parentModule = (Module)unit.getParent().getAttachment(Attachments.MODULE);
            if (parentModule == null) {
                throw WSLogger.ROOT_LOGGER.classLoaderResolutionFailed(deploymentRoot);
            }
            WSLogger.ROOT_LOGGER.tracef("Creating new unified WS deployment model for %s", unit.getParent());
            parentDep = this.newDeployment(null, unit.getParent().getName(), (ClassLoader)parentModule.getClassLoader(), null);
        }
        VirtualFileAdaptor uvf = root != null ? new VirtualFileAdaptor(root) : new ResourceLoaderAdapter((ClassLoader)classLoader);
        ArchiveDeployment dep = this.newDeployment(parentDep, unit.getName(), (ClassLoader)classLoader, uvf);
        dep.addAttachment(AnnotationsInfo.class, (Object)new JandexAnnotationsInfo(unit));
        return dep;
    }

    private ArchiveDeployment newDeployment(ArchiveDeployment parent, String name, ClassLoader loader, UnifiedVirtualFile rootFile) {
        if (parent != null) {
            return (ArchiveDeployment)this.deploymentModelFactory.newDeployment(parent, name, loader, rootFile);
        }
        return (ArchiveDeployment)this.deploymentModelFactory.newDeployment(name, loader, rootFile);
    }
}

