/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.InterruptedIOException;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.util.Responses;
import org.jgroups.util.UUID;

public class PING
extends Discovery {
    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        try {
            this.sendDiscoveryRequest(this.cluster_name, members);
        }
        catch (InterruptedIOException ie) {
        }
        catch (InterruptedException ex) {
        }
        catch (Throwable ex) {
            this.log.error("failed sending discovery request", ex);
        }
    }

    protected void sendDiscoveryRequest(String cluster_name, List<Address> members_to_find) throws Exception {
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        PingData data = new PingData(this.local_addr, false, UUID.get(this.local_addr), physical_addr);
        PingHeader hdr = new PingHeader(1).clusterName(cluster_name);
        if (members_to_find != null && members_to_find.size() <= this.max_members_in_discovery_request) {
            data.mbrs(members_to_find);
        }
        Message msg = new Message(null).putHeader(this.getId(), hdr).setBuffer(PING.marshal(data)).setFlag(Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
        this.sendMcastDiscoveryRequest(msg);
    }

    protected void sendMcastDiscoveryRequest(Message msg) {
        this.down_prot.down(new Event(1, msg));
    }
}

