/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jgroups.Address;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;
import org.w3c.dom.Document;

@Experimental
public class SWIFT_PING
extends FILE_PING {
    private static final Log log = LogFactory.getLog(SWIFT_PING.class);
    protected SwiftClient swiftClient = null;
    @Property(description="Authentication url")
    protected String auth_url = null;
    @Property(description="Authentication type")
    protected String auth_type = "keystone_v_2_0";
    @Property(description="Openstack Keystone tenant name")
    protected String tenant = null;
    @Property(description="Username")
    protected String username = null;
    @Property(description="Password", exposeAsManagedAttribute=false)
    protected String password = null;
    @Property(description="Name of the root container")
    protected String container = "jgroups";

    @Override
    public void init() throws Exception {
        Utils.validateNotEmpty(this.auth_url, "auth_url");
        Utils.validateNotEmpty(this.auth_type, "auth_type");
        Utils.validateNotEmpty(this.username, "username");
        Utils.validateNotEmpty(this.password, "password");
        Utils.validateNotEmpty(this.container, "container");
        Authenticator authenticator = this.createAuthenticator();
        authenticator.validateParams();
        this.swiftClient = new SwiftClient(authenticator);
        this.swiftClient.authenticate();
        super.init();
    }

    private Authenticator createAuthenticator() throws Exception {
        AUTH_TYPE authType = AUTH_TYPE.getByConfigName(this.auth_type);
        if (authType == null) {
            throw new IllegalArgumentException("Invalid 'auth_type' : " + this.auth_type);
        }
        URL authUrl = new URL(this.auth_url);
        Keystone_V_2_0_Auth authenticator = null;
        switch (authType) {
            case KEYSTONE_V_2_0: {
                authenticator = new Keystone_V_2_0_Auth(this.tenant, authUrl, this.username, this.password);
                break;
            }
            default: {
                throw new IllegalStateException("Could not select authenticator");
            }
        }
        return authenticator;
    }

    @Override
    protected void createRootDir() {
        try {
            this.swiftClient.createContainer(this.container);
        }
        catch (Exception e) {
            log.error("failure creating container", e);
        }
    }

    @Override
    protected void readAll(List<Address> members, String clustername, Responses responses) {
        try {
            List<String> objects = this.swiftClient.listObjects(this.container);
            for (String object : objects) {
                List<PingData> list = null;
                byte[] bytes = this.swiftClient.readObject(this.container, object);
                list = this.read(new ByteArrayInputStream(bytes));
                if (list == null) {
                    log.warn("failed reading " + object);
                    continue;
                }
                for (PingData data : list) {
                    if (members == null || members.contains(data.getAddress())) {
                        responses.addResponse(data, data.isCoord());
                    }
                    if (this.local_addr == null || this.local_addr.equals(data.getAddress())) continue;
                    this.addDiscoveryResponseToCaches(data.getAddress(), data.getLogicalName(), data.getPhysicalAddr());
                }
            }
        }
        catch (Exception e) {
            log.error("Error unmarshalling object", e);
        }
    }

    @Override
    protected void write(List<PingData> list, String clustername) {
        try {
            String filename = clustername + "/" + SWIFT_PING.addressToFilename(this.local_addr);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            this.write(list, out);
            byte[] data = out.toByteArray();
            this.swiftClient.createObject(this.container, filename, data);
        }
        catch (Exception e) {
            log.error("Error marshalling object", e);
        }
    }

    @Override
    protected void remove(String clustername, Address addr) {
        String fileName = clustername + "/" + SWIFT_PING.addressToFilename(addr);
        try {
            this.swiftClient.deleteObject(this.container, fileName);
        }
        catch (Exception e) {
            log.error("failure removing data", e);
        }
    }

    @Override
    protected void removeAll(String clustername) {
        try {
            List<String> objects = this.swiftClient.listObjects(this.container);
            for (String objName : objects) {
                this.swiftClient.deleteObject(this.container, objName);
            }
        }
        catch (Exception t) {
            log.error("failed removing objects", t);
        }
    }

    private static class Utils {
        private Utils() {
        }

        public static void validateNotEmpty(String arg, String argname) {
            if (arg == null || arg.trim().length() == 0) {
                throw new IllegalArgumentException("'" + argname + "' cannot be empty");
            }
        }

        public static boolean isSuccessCode(int code) {
            return code >= 200 && code < 300;
        }

        public static boolean isAuthDenied(int code) {
            return code == 401;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HttpResponse doOperation(HttpURLConnection urlConnection, byte[] inputData, boolean hasOutput) throws IOException {
            HttpResponse response = null;
            Closeable inputStream = null;
            OutputStream outputStream = null;
            byte[] payload = null;
            try {
                if (inputData != null) {
                    urlConnection.setDoOutput(true);
                    outputStream = urlConnection.getOutputStream();
                    outputStream.write(inputData);
                }
                int responseCode = urlConnection.getResponseCode();
                if (hasOutput && Utils.isSuccessCode(responseCode)) {
                    payload = Utils.getBytes(urlConnection.getInputStream());
                }
                response = new HttpResponse(urlConnection.getHeaderFields(), responseCode, payload);
            }
            catch (Throwable throwable) {
                Util.close(inputStream);
                Util.close(outputStream);
                throw throwable;
            }
            Util.close(inputStream);
            Util.close((Closeable)outputStream);
            return response;
        }

        public static byte[] getBytes(InputStream inputStream) throws IOException {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            return baos.toByteArray();
        }

        public static HttpResponse doVoidOperation(HttpURLConnection urlConnection) throws IOException {
            return Utils.doOperation(urlConnection, null, false);
        }

        public static HttpResponse doSendOperation(HttpURLConnection urlConnection, byte[] content) throws IOException {
            return Utils.doOperation(urlConnection, content, false);
        }

        public static HttpResponse doReadOperation(HttpURLConnection urlConnection) throws IOException {
            return Utils.doOperation(urlConnection, null, true);
        }
    }

    protected static class SwiftClient {
        private Authenticator authenticator;
        private volatile Credentials credentials = null;

        public SwiftClient(Authenticator authenticator) {
            this.authenticator = authenticator;
        }

        public void authenticate() throws Exception {
            this.credentials = this.authenticator.authenticate();
        }

        public void deleteObject(String containerName, String objectName) throws Exception {
            HttpURLConnection urlConnection = this.getConnBuilder(containerName, objectName).method("DELETE").getConnection();
            HttpResponse response = Utils.doVoidOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    this.deleteObject(containerName, objectName);
                } else {
                    log.error("Error deleting object " + objectName + " from container " + containerName + ",code = " + response.code);
                }
            }
        }

        public void createContainer(String containerName) throws Exception {
            HttpURLConnection urlConnection = this.getConnBuilder(containerName, null).method("PUT").getConnection();
            HttpResponse response = Utils.doVoidOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    this.createContainer(containerName);
                } else {
                    log.error("Error creating container " + containerName + " ,code = " + response.code);
                }
            }
        }

        public void createObject(String containerName, String objectName, byte[] contents) throws Exception {
            HttpURLConnection conn = this.getConnBuilder(containerName, objectName).method("PUT").addHeader("Content-Length", String.valueOf(contents.length)).getConnection();
            HttpResponse response = Utils.doSendOperation(conn, contents);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    this.createObject(containerName, objectName, contents);
                } else {
                    log.error("Error creating object " + objectName + " in container " + containerName + ",code = " + response.code);
                }
            }
        }

        public byte[] readObject(String containerName, String objectName) throws Exception {
            HttpURLConnection urlConnection = this.getConnBuilder(containerName, objectName).getConnection();
            HttpResponse response = Utils.doReadOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    return this.readObject(containerName, objectName);
                }
                log.error("Error reading object " + objectName + " from container " + containerName + ", code = " + response.code);
            }
            return response.payload;
        }

        public List<String> listObjects(String containerName) throws Exception {
            HttpURLConnection urlConnection = this.getConnBuilder(containerName, null).getConnection();
            HttpResponse response = Utils.doReadOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    return this.listObjects(containerName);
                }
                log.error("Error listing container " + containerName + ", code = " + response.code);
            }
            return response.payloadAsLines();
        }

        private ConnBuilder getConnBuilder(String container, String object) {
            ConnBuilder connBuilder = new ConnBuilder(this.credentials, container, object);
            connBuilder.addHeader("X-Storage-Token", this.credentials.authToken);
            connBuilder.addHeader("Accept", "*/*");
            return connBuilder;
        }
    }

    private static class HttpResponse {
        private final Map<String, List<String>> headers;
        private final int code;
        private final byte[] payload;

        HttpResponse(Map<String, List<String>> headers, int code, byte[] payload) {
            this.headers = headers;
            this.code = code;
            this.payload = payload;
        }

        public List<String> payloadAsLines() {
            ArrayList<String> lines = new ArrayList<String>();
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.payload)));
                while ((line = in.readLine()) != null) {
                    lines.add(line);
                }
                in.close();
            }
            catch (IOException e) {
                log.error("Error reading objects", e);
            }
            return lines;
        }

        public boolean isSuccessCode() {
            return Utils.isSuccessCode(this.code);
        }

        public boolean isAuthDenied() {
            return Utils.isAuthDenied(this.code);
        }
    }

    private static class ConnBuilder {
        private HttpURLConnection con;

        public ConnBuilder(URL url) {
            try {
                this.con = (HttpURLConnection)url.openConnection();
            }
            catch (IOException e) {
                log.error("Error building URL", e);
            }
        }

        public ConnBuilder(Credentials credentials, String container, String object) {
            try {
                String url = credentials.storageUrl + "/" + container;
                if (object != null) {
                    url = url + "/" + object;
                }
                this.con = (HttpURLConnection)new URL(url).openConnection();
            }
            catch (IOException e) {
                log.error("Error creating connection", e);
            }
        }

        public ConnBuilder method(String method) {
            try {
                this.con.setRequestMethod(method);
            }
            catch (ProtocolException e) {
                log.error("Protocol error", e);
            }
            return this;
        }

        public ConnBuilder addHeader(String key, String value) {
            this.con.setRequestProperty(key, value);
            return this;
        }

        public HttpURLConnection getConnection() {
            return this.con;
        }
    }

    private static class Keystone_V_2_0_Auth
    implements Authenticator {
        private static XPathExpression tokenIdExpression;
        private static XPathExpression publicUrlExpression;
        private String tenant;
        private URL authUrl;
        private String username;
        private String password;

        public Keystone_V_2_0_Auth(String tenant, URL authUrl, String username, String password) {
            this.tenant = tenant;
            this.authUrl = authUrl;
            this.username = username;
            this.password = password;
        }

        @Override
        public void validateParams() {
            Utils.validateNotEmpty(this.tenant, "tenant");
        }

        @Override
        public Credentials authenticate() throws Exception {
            HttpURLConnection urlConnection = new ConnBuilder(this.authUrl).addHeader("Content-type", "application/json").addHeader("Accept", "application/xml").getConnection();
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{\"auth\": {\"tenantName\": \"").append(this.tenant).append("\", \"passwordCredentials\": {\"username\": \"").append(this.username).append("\", \"password\": \"").append(this.password).append("\"}}}");
            HttpResponse response = Utils.doOperation(urlConnection, jsonBuilder.toString().getBytes(), true);
            if (response.isSuccessCode()) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(response.payload));
                String authToken = (String)tokenIdExpression.evaluate(doc, XPathConstants.STRING);
                String storageUrl = (String)publicUrlExpression.evaluate(doc, XPathConstants.STRING);
                log.trace("Authentication successful");
                return new Credentials(authToken, storageUrl);
            }
            throw new IllegalStateException("Error authenticating to the service. Please check your credentials. Code = " + response.code);
        }

        static {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            try {
                tokenIdExpression = xpath.compile("/access/token/@id");
                publicUrlExpression = xpath.compile("/access/serviceCatalog/service[@type='object-store']/endpoint/@publicURL");
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
    }

    private static interface Authenticator {
        public void validateParams();

        public Credentials authenticate() throws Exception;
    }

    private static class Credentials {
        private final String authToken;
        private final String storageUrl;

        public Credentials(String authToken, String storageUrl) {
            this.authToken = authToken;
            this.storageUrl = storageUrl;
        }
    }

    private static enum AUTH_TYPE {
        KEYSTONE_V_2_0("keystone_v_2_0");

        private static final Map<String, AUTH_TYPE> LOOKUP;
        private String configName;

        private AUTH_TYPE(String externalName) {
            this.configName = externalName;
        }

        public static AUTH_TYPE getByConfigName(String configName) {
            return LOOKUP.get(configName);
        }

        static {
            LOOKUP = new HashMap<String, AUTH_TYPE>();
            for (AUTH_TYPE type : EnumSet.allOf(AUTH_TYPE.class)) {
                LOOKUP.put(type.configName, type);
            }
        }
    }

    private static class HttpHeaders {
        private static final String CONTENT_TYPE_HEADER = "Content-type";
        private static final String ACCEPT_HEADER = "Accept";
        private static final String STORAGE_TOKEN_HEADER = "X-Storage-Token";
        private static final String CONTENT_LENGTH_HEADER = "Content-Length";

        private HttpHeaders() {
        }
    }
}

