/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.connectionfactory;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

public class PooledConnectionFactory
extends ConnectionFactory {
    private static final Log log = (Log)LogFactory.getLog(PooledConnectionFactory.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private ComboPooledDataSource pooledDataSource;

    @Override
    public void start(ConnectionFactoryConfiguration config, ClassLoader classLoader) throws PersistenceException {
        this.logFileOverride(classLoader);
        if (!(config instanceof PooledConnectionFactoryConfiguration)) {
            throw new PersistenceException("ConnectionFactoryConfiguration passed in must be an instance of PooledConnectionFactoryConfiguration");
        }
        PooledConnectionFactoryConfiguration pooledConfiguration = (PooledConnectionFactoryConfiguration)config;
        this.pooledDataSource = new ComboPooledDataSource();
        this.pooledDataSource.setProperties(new Properties());
        try {
            Class.forName(pooledConfiguration.driverClass(), true, ComboPooledDataSource.class.getClassLoader());
            this.pooledDataSource.setDriverClass(pooledConfiguration.driverClass());
        }
        catch (Exception e) {
            log.errorInstantiatingJdbcDriver(pooledConfiguration.driverClass(), e);
            throw new PersistenceException(String.format("Error while instatianting JDBC driver: '%s'", pooledConfiguration.driverClass()), (Throwable)e);
        }
        this.pooledDataSource.setJdbcUrl(pooledConfiguration.connectionUrl());
        this.pooledDataSource.setUser(pooledConfiguration.username());
        this.pooledDataSource.setPassword(pooledConfiguration.password());
        if (trace) {
            log.tracef("Started connection factory with config: %s", config);
        }
    }

    private void logFileOverride(ClassLoader classLoader) {
        URL propsUrl = FileLookupFactory.newInstance().lookupFileLocation("c3p0.properties", classLoader);
        URL xmlUrl = FileLookupFactory.newInstance().lookupFileLocation("c3p0-config.xml", classLoader);
        if (log.isDebugEnabled() && propsUrl != null) {
            log.debugf("Found 'c3p0.properties' in classpath: %s", propsUrl);
        }
        if (log.isDebugEnabled() && xmlUrl != null) {
            log.debugf("Found 'c3p0-config.xml' in classpath: %s", xmlUrl);
        }
    }

    @Override
    public void stop() {
        try {
            DataSources.destroy((DataSource)this.pooledDataSource);
            if (log.isDebugEnabled()) {
                log.debug("Successfully stopped PooledConnectionFactory.");
            }
        }
        catch (SQLException sqle) {
            log.couldNotDestroyC3p0ConnectionPool(this.pooledDataSource != null ? this.pooledDataSource.toString() : null, sqle);
        }
    }

    @Override
    public Connection getConnection() throws PersistenceException {
        try {
            this.logBefore(true);
            Connection connection = this.pooledDataSource.getConnection();
            this.logAfter(connection, true);
            return connection;
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed obtaining connection from PooledDataSource", (Throwable)e);
        }
    }

    @Override
    public void releaseConnection(Connection conn) {
        this.logBefore(false);
        JdbcUtil.safeClose(conn);
        this.logAfter(conn, false);
    }

    public ComboPooledDataSource getPooledDataSource() {
        return this.pooledDataSource;
    }

    private void logBefore(boolean checkout) {
        if (trace) {
            String operation = checkout ? "checkout" : "release";
            try {
                log.tracef("DataSource before %s (NumBusyConnectionsAllUsers) : %d, (NumConnectionsAllUsers) : %d", operation, this.pooledDataSource.getNumBusyConnectionsAllUsers(), this.pooledDataSource.getNumConnectionsAllUsers());
            }
            catch (SQLException e) {
                log.sqlFailureUnexpected(e);
            }
        }
    }

    private void logAfter(Connection connection, boolean checkout) {
        if (trace) {
            String operation = checkout ? "checkout" : "release";
            try {
                log.tracef("DataSource after %s (NumBusyConnectionsAllUsers) : %d, (NumConnectionsAllUsers) : %d", operation, this.pooledDataSource.getNumBusyConnectionsAllUsers(), this.pooledDataSource.getNumConnectionsAllUsers());
            }
            catch (SQLException e) {
                log.sqlFailureUnexpected(e);
            }
            log.tracef("Connection %s : %s", operation, connection);
        }
    }
}

