/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.jboss.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.jboss.MarshalledValue;
import org.wildfly.clustering.marshalling.jboss.Marshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.SessionAttributes;

public class CoarseSessionAttributesFactory
implements SessionAttributesFactory<Map.Entry<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>>> {
    private final Cache<SessionAttributesKey, MarshalledValue<Map<String, Object>, MarshallingContext>> cache;
    private final Marshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>, MarshallingContext> marshaller;
    private final boolean transactional;
    private final boolean lockOnRead;
    private final boolean requireMarshallable;

    public CoarseSessionAttributesFactory(Cache<? extends Key<String>, ?> cache, Marshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>, MarshallingContext> marshaller, boolean lockOnRead, boolean requireMarshallable) {
        this.cache = cache;
        this.marshaller = marshaller;
        this.transactional = cache.getCacheConfiguration().transaction().transactionMode().isTransactional();
        this.lockOnRead = lockOnRead;
        this.requireMarshallable = requireMarshallable;
    }

    public Map.Entry<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> createValue(String id, Void context) {
        SessionAttributesKey attributesKey = new SessionAttributesKey(id);
        MarshalledValue value = (MarshalledValue)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).computeIfAbsent((Object)attributesKey, key -> (MarshalledValue)this.marshaller.write(this.lockOnRead ? new HashMap() : new ConcurrentHashMap()));
        try {
            Map attributes = (Map)this.marshaller.read((Object)value);
            return new AbstractMap.SimpleImmutableEntry<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>>(attributes, value);
        }
        catch (InvalidSerializedFormException e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, id);
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)attributesKey);
            return this.createValue(id, context);
        }
    }

    public Map.Entry<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> findValue(String id) {
        MarshalledValue value = (MarshalledValue)this.cache.get((Object)new SessionAttributesKey(id));
        if (value != null) {
            try {
                Map attributes = (Map)this.marshaller.read((Object)value);
                return new AbstractMap.SimpleImmutableEntry<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>>(attributes, value);
            }
            catch (InvalidSerializedFormException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, id);
                this.remove(id);
            }
        }
        return null;
    }

    public void remove(String id) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAttributesKey(id));
    }

    public void evict(String id) {
        this.cache.evict((Object)new SessionAttributesKey(id));
    }

    @Override
    public SessionAttributes createSessionAttributes(String id, Map.Entry<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> entry) {
        SessionAttributesKey key = new SessionAttributesKey(id);
        CacheEntryMutator mutator = this.transactional && this.cache.getAdvancedCache().getCacheEntry((Object)key).isCreated() ? Mutator.PASSIVE : new CacheEntryMutator(this.cache, (Object)key, entry.getValue());
        return new CoarseSessionAttributes(entry.getKey(), (Mutator)mutator, (MarshallingContext)this.marshaller.getContext(), this.requireMarshallable);
    }

    @Override
    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map.Entry<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> entry) {
        return new CoarseImmutableSessionAttributes(entry.getKey());
    }
}

