/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupAction;
import java.util.List;

public class CompositeThreadSetupAction
implements ThreadSetupAction {
    private final ThreadSetupAction[] actions;

    public CompositeThreadSetupAction(List<ThreadSetupAction> actions) {
        this.actions = actions.toArray(new ThreadSetupAction[actions.size()]);
    }

    @Override
    public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
        final ThreadSetupAction.Handle[] handles = new ThreadSetupAction.Handle[this.actions.length];
        try {
            for (int i = 0; i < handles.length; ++i) {
                handles[handles.length - i - 1] = this.actions[i].setup(exchange);
            }
            return new ThreadSetupAction.Handle(){

                @Override
                public void tearDown() {
                    Throwable problem = null;
                    for (int i = 0; i < handles.length; ++i) {
                        ThreadSetupAction.Handle handle = handles[i];
                        if (handle == null) continue;
                        try {
                            handle.tearDown();
                            continue;
                        }
                        catch (Throwable e) {
                            problem = e;
                        }
                    }
                    if (problem != null) {
                        throw new RuntimeException(problem);
                    }
                }
            };
        }
        catch (RuntimeException e) {
            for (ThreadSetupAction.Handle handle : handles) {
                try {
                    handle.tearDown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (Error e) {
            for (ThreadSetupAction.Handle handle : handles) {
                try {
                    handle.tearDown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
    }
}

