/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;

public abstract class MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>> {
    protected AttributeNode<AttributeMetadata, AttributeId> rootNode;
    protected AttributeNode<AttributeMetadata, AttributeId> currentNode;
    private final Object userContext;
    private final Object instance;
    private final Object eventType;
    private FilterEvalContext singleFilterContext;
    private FilterEvalContext[] filterContexts;
    private List<FilterSubscriptionImpl> filterSubscriptions;
    private Map<Predicate<?>, Counter> suspendedPredicateSubscriptionCounts;

    protected MatcherEvalContext(Object userContext, Object eventType, Object instance) {
        this.userContext = userContext;
        this.eventType = eventType;
        this.instance = instance;
    }

    public abstract TypeMetadata getEntityType();

    public Object getInstance() {
        return this.instance;
    }

    public Object getUserContext() {
        return this.userContext;
    }

    public Object getEventType() {
        return this.eventType;
    }

    public void initMultiFilterContext(FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> filterRegistry) {
        this.rootNode = filterRegistry.getPredicateIndex().getRoot();
        this.suspendedPredicateSubscriptionCounts = new HashMap();
        this.filterSubscriptions = filterRegistry.getFilterSubscriptions();
        this.filterContexts = new FilterEvalContext[filterRegistry.getFilterSubscriptions().size()];
    }

    public FilterEvalContext initSingleFilterContext(FilterSubscriptionImpl filterSubscription) {
        this.singleFilterContext = new FilterEvalContext(this, filterSubscription);
        return this.singleFilterContext;
    }

    private boolean isSingleFilter() {
        return this.singleFilterContext != null;
    }

    public FilterEvalContext getFilterEvalContext(FilterSubscriptionImpl filterSubscription) {
        if (this.isSingleFilter()) {
            return this.singleFilterContext;
        }
        FilterEvalContext filterEvalContext = this.filterContexts[filterSubscription.index];
        if (filterEvalContext == null) {
            this.filterContexts[filterSubscription.index] = filterEvalContext = new FilterEvalContext(this, filterSubscription);
        }
        return filterEvalContext;
    }

    public void addSuspendedSubscription(Predicate<?> predicate) {
        if (this.isSingleFilter()) {
            return;
        }
        Counter counter = this.suspendedPredicateSubscriptionCounts.get(predicate);
        if (counter == null) {
            counter = new Counter();
            this.suspendedPredicateSubscriptionCounts.put(predicate, counter);
        }
        ++counter.value;
    }

    public int getSuspendedSubscriptionsCounter(Predicate<AttributeId> predicate) {
        if (this.isSingleFilter()) {
            return -1;
        }
        Counter counter = this.suspendedPredicateSubscriptionCounts.get(predicate);
        return counter == null ? 0 : counter.value;
    }

    public AttributeNode<AttributeMetadata, AttributeId> getRootNode() {
        return this.rootNode;
    }

    public void process(AttributeNode<AttributeMetadata, AttributeId> node) {
        this.currentNode = node;
        this.processAttributes(this.currentNode, this.instance);
    }

    public void notifySubscribers() {
        if (this.isSingleFilter()) {
            return;
        }
        for (int i = 0; i < this.filterContexts.length; ++i) {
            FilterSubscriptionImpl s = this.filterSubscriptions.get(i);
            FilterEvalContext filterEvalContext = this.filterContexts[i];
            if (filterEvalContext == null) {
                if (s.getBETree().getChildCounters()[0] != 0) continue;
                this.filterContexts[i] = filterEvalContext = new FilterEvalContext(this, s);
            }
            if (!filterEvalContext.isMatching()) continue;
            s.getCallback().onFilterResult(false, this.userContext, this.eventType, this.instance, filterEvalContext.getProjection(), filterEvalContext.getSortProjection());
        }
    }

    public void notifyDeltaSubscribers(MatcherEvalContext other, Object joiningEvent, Object leavingEvent) {
        if (this.isSingleFilter()) {
            return;
        }
        for (int i = 0; i < this.filterContexts.length; ++i) {
            boolean after;
            FilterSubscriptionImpl s = this.filterSubscriptions.get(i);
            FilterEvalContext filterEvalContext1 = this.filterContexts[i];
            if (filterEvalContext1 == null && s.getBETree().getChildCounters()[0] == 0) {
                this.filterContexts[i] = filterEvalContext1 = new FilterEvalContext(this, s);
            }
            FilterEvalContext filterEvalContext2 = null;
            if (other != null && (filterEvalContext2 = other.filterContexts[i]) == null && s.getBETree().getChildCounters()[0] == 0) {
                other.filterContexts[i] = filterEvalContext2 = new FilterEvalContext(other, s);
            }
            boolean before = filterEvalContext1 != null && filterEvalContext1.isMatching();
            boolean bl = after = filterEvalContext2 != null && filterEvalContext2.isMatching();
            if (!before && after) {
                s.getCallback().onFilterResult(true, this.userContext, joiningEvent, this.instance, filterEvalContext2.getProjection(), filterEvalContext2.getSortProjection());
                continue;
            }
            if (!before || after) continue;
            s.getCallback().onFilterResult(true, this.userContext, leavingEvent, this.instance, filterEvalContext1.getProjection(), filterEvalContext1.getSortProjection());
        }
    }

    protected abstract void processAttributes(AttributeNode<AttributeMetadata, AttributeId> var1, Object var2);

    private static final class Counter {
        int value;

        private Counter() {
        }
    }
}

