/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.marshalling.jboss.MarshalledValue;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;

public class InfinispanBeanGroupEntry<I, T>
implements BeanGroupEntry<I, T> {
    private final MarshalledValue<Map<I, T>, MarshallingContext> beans;
    private final ConcurrentMap<I, AtomicInteger> usage = new ConcurrentHashMap<I, AtomicInteger>();

    public InfinispanBeanGroupEntry(MarshalledValue<Map<I, T>, MarshallingContext> beans) {
        this.beans = beans;
    }

    @Override
    public MarshalledValue<Map<I, T>, MarshallingContext> getBeans() {
        return this.beans;
    }

    @Override
    public int incrementUsage(I id) {
        AtomicInteger old;
        AtomicInteger count = (AtomicInteger)this.usage.get(id);
        if (count == null && (old = this.usage.putIfAbsent(id, count = new AtomicInteger())) != null) {
            count = old;
        }
        return count.getAndIncrement();
    }

    @Override
    public int decrementUsage(I id) {
        AtomicInteger count = (AtomicInteger)this.usage.get(id);
        return count != null ? count.decrementAndGet() : 0;
    }

    @Override
    public int totalUsage() {
        int total = 0;
        for (AtomicInteger count : this.usage.values()) {
            total += count.get();
        }
        return total;
    }
}

