/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.replication.ReplicationManager;

public class ReplicationAddTXMessage
extends PacketImpl {
    private long txId;
    private long id;
    private byte journalID;
    private byte recordType;
    private EncodingSupport encodingData;
    private byte[] recordData;
    private ReplicationManager.ADD_OPERATION_TYPE operation;

    public ReplicationAddTXMessage() {
        super((byte)92);
    }

    public ReplicationAddTXMessage(byte journalID, ReplicationManager.ADD_OPERATION_TYPE operation, long txId, long id, byte recordType, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.operation = operation;
        this.txId = txId;
        this.id = id;
        this.recordType = recordType;
        this.encodingData = encodingData;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeBoolean(this.operation.toBoolean());
        buffer.writeLong(this.txId);
        buffer.writeLong(this.id);
        buffer.writeByte(this.recordType);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.operation = ReplicationManager.ADD_OPERATION_TYPE.toOperation(buffer.readBoolean());
        this.txId = buffer.readLong();
        this.id = buffer.readLong();
        this.recordType = buffer.readByte();
        int recordDataSize = buffer.readInt();
        this.recordData = new byte[recordDataSize];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public ReplicationManager.ADD_OPERATION_TYPE getOperation() {
        return this.operation;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encodingData == null ? 0 : this.encodingData.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.journalID;
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + Arrays.hashCode(this.recordData);
        result = 31 * result + this.recordType;
        result = 31 * result + (int)(this.txId ^ this.txId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationAddTXMessage)) {
            return false;
        }
        ReplicationAddTXMessage other = (ReplicationAddTXMessage)obj;
        if (this.encodingData == null ? other.encodingData != null : !this.encodingData.equals(other.encodingData)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.journalID != other.journalID) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        if (!Arrays.equals(this.recordData, other.recordData)) {
            return false;
        }
        if (this.recordType != other.recordType) {
            return false;
        }
        return this.txId == other.txId;
    }
}

