/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.jgroups.subsystem.ChannelRemoveHandler;
import org.infinispan.server.jgroups.subsystem.ChannelResourceDefinition;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemAddHandler;
import org.infinispan.server.jgroups.subsystem.StackRemoveHandler;
import org.infinispan.server.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class JGroupsSubsystemRemoveHandler
extends AbstractRemoveStepHandler {
    private final boolean allowRuntimeOnlyRegistration;

    JGroupsSubsystemRemoveHandler(boolean allowRuntimeOnlyRegistration) {
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    protected void performRemove(OperationContext context, ModelNode operation, final ModelNode model) throws OperationFailedException {
        ModelNode stacks;
        ModelNode channels;
        PathAddress address = context.getCurrentAddress();
        if (model.hasDefined(ChannelResourceDefinition.WILDCARD_PATH.getKey()) && (channels = model.get(ChannelResourceDefinition.WILDCARD_PATH.getKey())).isDefined()) {
            for (Property channel : channels.asPropertyList()) {
                PathAddress channelAddress = address.append(new PathElement[]{ChannelResourceDefinition.pathElement(channel.getName())});
                context.addStep(Util.createRemoveOperation((PathAddress)channelAddress), (OperationStepHandler)new ChannelRemoveHandler(this.allowRuntimeOnlyRegistration), OperationContext.Stage.MODEL);
            }
        }
        if (model.hasDefined(StackResourceDefinition.WILDCARD_PATH.getKey()) && (stacks = model.get(StackResourceDefinition.WILDCARD_PATH.getKey())).isDefined()) {
            for (Property stack : stacks.asPropertyList()) {
                PathAddress stackAddress = address.append(new PathElement[]{StackResourceDefinition.pathElement(stack.getName())});
                context.addStep(Util.createRemoveOperation((PathAddress)stackAddress), (OperationStepHandler)new StackRemoveHandler(), OperationContext.Stage.MODEL);
            }
        }
        context.addStep(operation, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                JGroupsSubsystemRemoveHandler.super.performRemove(context, operation, model);
            }
        }, OperationContext.Stage.MODEL);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        JGroupsSubsystemAddHandler.removeRuntimeServices(context, operation, model);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        JGroupsSubsystemAddHandler.installRuntimeServices(context, operation, model);
    }
}

