/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.reflect;

import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.invocation.proxy.MethodIdentifier;

public class ClassReflectionIndexUtil {
    public static Method findMethod(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> clazz, MethodIdentifier methodIdentifier) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(c);
            Method method = index.getMethod(methodIdentifier);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static Method findRequiredMethod(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> clazz, MethodIdentifier methodIdentifier) throws DeploymentUnitProcessingException {
        Method method = ClassReflectionIndexUtil.findMethod(deploymentReflectionIndex, clazz, methodIdentifier);
        if (method == null) {
            throw ServerLogger.ROOT_LOGGER.noMethodFound(methodIdentifier, clazz);
        }
        return method;
    }

    public static Method findRequiredMethod(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> clazz, Method method) throws DeploymentUnitProcessingException {
        if (method == null) {
            throw ServerLogger.ROOT_LOGGER.nullMethod();
        }
        MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)method);
        return ClassReflectionIndexUtil.findRequiredMethod(deploymentReflectionIndex, clazz, methodIdentifier);
    }

    public static Method findMethod(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> clazz, Method method) {
        if (method == null) {
            throw ServerLogger.ROOT_LOGGER.nullMethod();
        }
        MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)method);
        return ClassReflectionIndexUtil.findMethod(deploymentReflectionIndex, clazz, methodIdentifier);
    }

    public static Collection<Method> findMethods(DeploymentReflectionIndex deploymentReflectionIndex, ClassReflectionIndex classReflectionIndex, String methodName, String ... paramTypes) {
        ClassReflectionIndex superClassIndex;
        Collection<Method> methods = classReflectionIndex.getMethods(methodName, paramTypes);
        if (!methods.isEmpty()) {
            return methods;
        }
        Class<?> superClass = classReflectionIndex.getIndexedClass().getSuperclass();
        if (superClass != null && (superClassIndex = deploymentReflectionIndex.getClassIndex(superClass)) != null) {
            return ClassReflectionIndexUtil.findMethods(deploymentReflectionIndex, superClassIndex, methodName, paramTypes);
        }
        return methods;
    }

    public static Collection<Method> findAllMethods(DeploymentReflectionIndex deploymentReflectionIndex, ClassReflectionIndex classReflectionIndex, String methodName, int paramCount) {
        ClassReflectionIndex superClassIndex;
        Collection<Method> methods = classReflectionIndex.getAllMethods(methodName, paramCount);
        if (!methods.isEmpty()) {
            return methods;
        }
        Class<?> superClass = classReflectionIndex.getIndexedClass().getSuperclass();
        if (superClass != null && (superClassIndex = deploymentReflectionIndex.getClassIndex(superClass)) != null) {
            return ClassReflectionIndexUtil.findAllMethods(deploymentReflectionIndex, superClassIndex, methodName, paramCount);
        }
        return methods;
    }

    public static Collection<Method> findAllMethodsByName(DeploymentReflectionIndex deploymentReflectionIndex, ClassReflectionIndex classReflectionIndex, String methodName) {
        ClassReflectionIndex superClassIndex;
        Collection<Method> methods = classReflectionIndex.getAllMethods(methodName);
        if (!methods.isEmpty()) {
            return methods;
        }
        Class<?> superClass = classReflectionIndex.getIndexedClass().getSuperclass();
        if (superClass != null && (superClassIndex = deploymentReflectionIndex.getClassIndex(superClass)) != null) {
            return ClassReflectionIndexUtil.findAllMethodsByName(deploymentReflectionIndex, superClassIndex, methodName);
        }
        return methods;
    }
}

